/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.MapType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.StringType;

public final class TupleType
extends OclAnyType {
    private static List<Operation> operations;
    protected Map<String, OclAnyType> attributes;
    protected Map<String, EObject> eAttributes;

    public TupleType(Map<String, OclAnyType> attributes, Map<String, EObject> eAttributes) {
        super(new OclType(TupleType.computeName(attributes)));
        this.attributes = attributes;
        this.eAttributes = eAttributes;
    }

    @Override
    public OclAnyType[] getSupertypes() {
        return new OclAnyType[]{OclAnyType.getInstance()};
    }

    @Override
    public OclType getOclType() {
        return this.oclType;
    }

    @Override
    public List<Feature> getFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (String key : this.attributes.keySet()) {
            features.add(new Feature(null, this.eAttributes.get(key), key, this.oclType, this.attributes.get(key), false, false, 1, 1));
        }
        Collections.sort(features);
        return features;
    }

    @Override
    protected List<Operation> getTypeOperations() {
        if (operations == null) {
            operations = new ArrayList<Operation>(){
                {
                    this.add(new Operation("asMap", TupleType.getInstance(), null){

                        @Override
                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof TupleType) {
                                return new MapType(StringType.getInstance(), OclAnyType.getInstance());
                            }
                            return null;
                        }
                    });
                }
            };
        }
        return operations;
    }

    private static String computeName(Map<String, OclAnyType> attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Tuple");
        buffer.append('(');
        for (String key : attributes.keySet()) {
            buffer.append(String.valueOf(key) + ": " + attributes.get(key).toString() + ", ");
        }
        buffer.setLength(buffer.length() - 2);
        buffer.append(')');
        return buffer.toString();
    }
}

