/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.w3c.dom.Document;

public class XMLUtil {
    private static Logger _log = PDPlugin.getLogger(XMLUtil.class);

    public static synchronized DocumentBuilder getDocumentBuilder() {
        DocumentBuilder result = null;
        try {
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            _log.info("XMLUtil.Error.0", (Throwable)e);
        }
        return result;
    }

    public static void serialize(Document document, OutputStream ostream) throws IOException {
        DOMSource domSource = new DOMSource(document);
        try {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            try {
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                serializer.setOutputProperty("encoding", "UTF-8");
            }
            catch (IllegalArgumentException e) {
                _log.info("XMLUtil.Error.2", (Throwable)e);
            }
            serializer.transform(domSource, new StreamResult(ostream));
        }
        catch (TransformerConfigurationException e) {
            _log.info("XMLUtil.Error.2", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            _log.info("XMLUtil.Error.2", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            _log.info("XMLUtil.Error.2", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }
}

