/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.common.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.UnaryOperator;

class MinusUnaryOperator
extends UnaryOperator {
    private static final String UNARY_MINUS = "unary minus";

    MinusUnaryOperator(DiagnosticFactory diagnosticFactory) {
        super(diagnosticFactory);
    }

    @Override
    public Diagnostic validate(ValueType type) {
        if ("Ljava.lang.Object;".equals(type.getSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        try {
            String coercedType = TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)type.getSignature()));
            if (TypeCoercer.typeIsNull((String)coercedType)) {
                return this._diagnosticFactory.create_UNARY_OP_MINUS_ON_NULL_ALWAYS_ZERO();
            }
            if ("Ljava.math.BigDecimal;".equals(coercedType) || "Ljava.math.BigInteger;".equals(coercedType)) {
                return Diagnostic.OK_INSTANCE;
            }
            if (TypeCoercer.typeIsString((String)type.getSignature())) {
                if (type instanceof StringLiteralType) {
                    String literalValue = ((LiteralType)type).getLiteralValue();
                    if (literalValue.indexOf(46) > -1 || literalValue.indexOf(101) > -1 || literalValue.indexOf(69) > -1) {
                        ((LiteralType)type).coerceToNumber(Double.class);
                        return Diagnostic.OK_INSTANCE;
                    }
                    ((LiteralType)type).coerceToNumber(Long.class);
                    return Diagnostic.OK_INSTANCE;
                }
                return this._diagnosticFactory.create_UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED(UNARY_MINUS);
            }
            if (TypeCoercer.typeIsNumeric((String)coercedType)) {
                return Diagnostic.OK_INSTANCE;
            }
        }
        catch (TypeCoercionException typeCoercionException) {}
        return this._diagnosticFactory.create_UNARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(UNARY_MINUS);
    }

    @Override
    public ValueType performOperation(ValueType type) {
        try {
            String boxedType = TypeTransformer.transformBoxPrimitives((String)type.getSignature());
            String coercedType = TypeCoercer.coerceToNumber((String)boxedType);
            if (TypeCoercer.typeIsNull((String)coercedType)) {
                return new IntegerLiteralType(0L);
            }
            if ("Ljava.math.BigDecimal;".equals(coercedType)) {
                return new ValueType("Ljava.math.BigDecimal;", 2);
            }
            if ("Ljava.math.BigInteger;".equals(coercedType)) {
                return new ValueType("Ljava.math.BigInteger;", 2);
            }
            if (TypeCoercer.typeIsString((String)type.getSignature())) {
                if (type instanceof StringLiteralType) {
                    String literalValue = ((LiteralType)type).getLiteralValue();
                    if (literalValue.indexOf(46) > -1 || literalValue.indexOf(101) > -1 || literalValue.indexOf(69) > -1) {
                        Number value = ((LiteralType)type).coerceToNumber(Double.class);
                        return new FloatLiteralType(-1.0 * value.doubleValue());
                    }
                    Number value = ((LiteralType)type).coerceToNumber(Long.class);
                    return new IntegerLiteralType(-1L * value.longValue());
                }
                return new ValueType("J", 2);
            }
            if (TypeCoercer.typeIsNumeric((String)boxedType)) {
                if (type instanceof IntegerLiteralType) {
                    return new IntegerLiteralType(-1L * ((IntegerLiteralType)type).coerceToNumber(Long.class).longValue());
                }
                if (type instanceof FloatLiteralType) {
                    return new FloatLiteralType(-1.0 * ((FloatLiteralType)type).coerceToNumber(Double.class).doubleValue());
                }
                return type;
            }
        }
        catch (TypeCoercionException typeCoercionException) {}
        return null;
    }
}

