/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.libval;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.internal.libval.LibraryValidatorTools;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.libprov.JaxbUserLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.internal.libval.JaxbLibraryValidatorTools;
import org.eclipse.jpt.jaxb.core.internal.plugin.JptJaxbCorePlugin;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class GenericJaxbUserLibraryValidator
implements LibraryValidator {
    public synchronized IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        JaxbUserLibraryProviderInstallOperationConfig jaxbConfig = (JaxbUserLibraryProviderInstallOperationConfig)config;
        IProjectFacetVersion jaxbVersion = config.getProjectFacetVersion();
        IProjectFacetVersion javaVersion = LibraryValidatorTools.getJavaFacetVersion((JptLibraryProviderInstallOperationConfig)jaxbConfig);
        IProjectFacetVersion javaJaxbVersion = JaxbLibraryValidatorTools.findJavaJaxbVersion(jaxbConfig);
        IProjectFacetVersion jreJaxbVersion = JaxbLibraryValidatorTools.findJreJaxbVersion(jaxbConfig);
        if (jreJaxbVersion != null) {
            if (jreJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
                return JptJaxbCorePlugin.instance().buildErrorStatus(JptJaxbCoreMessages.USER_LIBRARY_VALIDATOR_INCOMPATIBLE_JAVA_LIBRARY, new Object[]{jaxbVersion.getVersionString()});
            }
        } else {
            IStatus status;
            HashSet<String> classNames = new HashSet<String>();
            classNames.add("javax.xml.bind.annotation.XmlSeeAlso");
            if (jaxbVersion.compareTo((Object)JaxbLibraryValidatorTools.FACET_VERSION_2_2) >= 0) {
                classNames.add("javax.xml.bind.JAXBPermission");
            }
            if (!(status = LibraryValidatorTools.validateClasses((UserLibraryProviderInstallOperationConfig)jaxbConfig, classNames)).isOK()) {
                return status;
            }
        }
        if (javaJaxbVersion != null && javaJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
            return JptJaxbCorePlugin.instance().buildStatus(2, JptJaxbCoreMessages.USER_LIBRARY_VALIDATOR_INCOMPATIBLE_JAVA_FACET, new Object[]{javaVersion.getVersionString(), jaxbVersion.getVersionString()});
        }
        return Status.OK_STATUS;
    }
}

