/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.checkouts;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.internal.explorer.AbstractManager;
import org.eclipse.emf.cdo.internal.explorer.checkouts.OfflineCDOCheckout;
import org.eclipse.emf.cdo.internal.explorer.checkouts.OnlineCDOCheckout;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;

public class CDOCheckoutManagerImpl
extends AbstractManager<CDOCheckout>
implements CDOCheckoutManager {
    private static final String PROPERTIES_FILE = "checkout.properties";
    private final Map<CDOView, CDOCheckout> viewMap = new ConcurrentHashMap<CDOView, CDOCheckout>();

    static {
        CDOID.ObjectType.values();
    }

    public CDOCheckoutManagerImpl(File folder) {
        super(CDOCheckout.class, folder);
    }

    @Override
    public String getPropertiesFileName() {
        return PROPERTIES_FILE;
    }

    @Override
    public CDOCheckout getCheckout(String id) {
        return (CDOCheckout)this.getElement(id);
    }

    @Override
    public CDOCheckout getCheckout(CDOView view) {
        return this.viewMap.get(view);
    }

    @Override
    public CDOCheckout getCheckoutByLabel(String label) {
        return (CDOCheckout)this.getElementByLabel(label);
    }

    @Override
    public CDOCheckout[] getCheckouts() {
        return (CDOCheckout[])this.getElements();
    }

    @Override
    public CDOCheckout addCheckout(Properties properties) {
        return (CDOCheckout)this.newElement(properties);
    }

    public void fireCheckoutOpenEvent(CDOCheckout checkout, CDOView view, CDOCheckout.State oldState, CDOCheckout.State newState) {
        if (view != null) {
            switch (newState) {
                case Open: {
                    this.viewMap.put(view, checkout);
                    break;
                }
                case Closed: {
                    this.viewMap.remove(view);
                }
            }
        }
        this.fireEvent(new CheckoutStateEventImpl(this, checkout, oldState, newState));
    }

    public void fireCheckoutInitializeEvent(CDOCheckout checkout) {
        this.fireEvent(new CheckoutInitializeEventImpl(this, checkout));
    }

    @Override
    protected CDOCheckout createElement(String type) {
        if ("online-transactional".equals(type)) {
            return new OnlineCDOCheckout();
        }
        if ("online-historical".equals(type)) {
            return new OnlineCDOCheckout(true);
        }
        if ("offline".equals(type)) {
            return new OfflineCDOCheckout();
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected CDOCheckout[] sortElements(CDOCheckout[] array) {
        Object[] sorted = (CDOCheckout[])super.sortElements((Object[])array);
        Arrays.sort(sorted);
        return sorted;
    }

    protected void doDeactivate() throws Exception {
        CDOCheckout[] cDOCheckoutArray = this.getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckout checkout = cDOCheckoutArray[n2];
            checkout.close();
            ++n2;
        }
        super.doDeactivate();
    }

    private static abstract class CheckoutEventImpl
    extends Event
    implements CDOCheckoutManager.CheckoutEvent {
        private static final long serialVersionUID = 1L;
        private final CDOCheckout checkout;

        public CheckoutEventImpl(CDOCheckoutManager checkoutManager, CDOCheckout checkout) {
            super((INotifier)checkoutManager);
            this.checkout = checkout;
        }

        @Override
        public CDOCheckoutManager getSource() {
            return (CDOCheckoutManager)super.getSource();
        }

        @Override
        public CDOCheckout getCheckout() {
            return this.checkout;
        }

        protected String formatAdditionalParameters() {
            return String.valueOf(this.checkout);
        }
    }

    private static final class CheckoutInitializeEventImpl
    extends CheckoutEventImpl
    implements CDOCheckoutManager.CheckoutInitializeEvent {
        private static final long serialVersionUID = 1L;

        public CheckoutInitializeEventImpl(CDOCheckoutManager checkoutManager, CDOCheckout checkout) {
            super(checkoutManager, checkout);
        }

        protected String formatEventName() {
            return CDOCheckoutManager.CheckoutInitializeEvent.class.getSimpleName();
        }
    }

    private static final class CheckoutStateEventImpl
    extends CheckoutEventImpl
    implements CDOCheckoutManager.CheckoutStateEvent {
        private static final long serialVersionUID = 1L;
        private final CDOCheckout.State oldState;
        private final CDOCheckout.State newState;

        public CheckoutStateEventImpl(CDOCheckoutManager checkoutManager, CDOCheckout checkout, CDOCheckout.State oldState, CDOCheckout.State newState) {
            super(checkoutManager, checkout);
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        public CDOCheckout.State getOldState() {
            return this.oldState;
        }

        @Override
        public CDOCheckout.State getNewState() {
            return this.newState;
        }

        protected String formatEventName() {
            return CDOCheckoutManager.CheckoutStateEvent.class.getSimpleName();
        }

        @Override
        protected String formatAdditionalParameters() {
            return String.valueOf(super.formatAdditionalParameters()) + ", " + (Object)((Object)this.oldState) + " --> " + (Object)((Object)this.newState);
        }
    }
}

