/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.gmf.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.cdo.dawn.internal.util.bundle.OM;
import org.eclipse.emf.cdo.dawn.util.exceptions.EClassIncompatibleException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class DawnResourceHelper {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DawnResourceHelper.class);

    public static String getXmiId(EObject eObject) {
        Resource xmiResource = eObject.eResource();
        if (xmiResource == null) {
            return null;
        }
        return ((XMLResource)xmiResource).getID(eObject);
    }

    public static String getXmiId(EObject eObject, Resource xmiResource) {
        if (xmiResource == null) {
            return null;
        }
        return ((XMLResource)xmiResource).getID(eObject);
    }

    public static void setXmiId(EObject eObject, String id) {
        Resource xmiResource = eObject.eResource();
        if (xmiResource != null) {
            ((XMLResource)xmiResource).setID(eObject, id);
        } else if (TRACER.isEnabled()) {
            TRACER.trace("Could set xmi id, because object is not attached to a resource!");
        }
    }

    public static Resource loadFromFile(String file, ResourceSet rsSet) {
        URI uri = URI.createURI((String)("file:/" + file));
        Resource res = rsSet.getResource(uri, true);
        return res;
    }

    public static void writeToFile(String path, String xml) throws IOException {
        File file = new File(path);
        FileWriter writer = new FileWriter(file);
        writer.write(xml);
        writer.close();
    }

    public static String saveToXML(XMLResource resource) throws IOException {
        resource.setXMLVersion("1.0");
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.putAll(resource.getDefaultSaveOptions());
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        XMIHelperImpl xmlHelper = new XMIHelperImpl(resource);
        XMISaveImpl x = new XMISaveImpl((XMLHelper)xmlHelper);
        StringWriter sw = new StringWriter();
        x.save(resource, (Writer)sw, saveOptions);
        return sw.toString();
    }

    public static Resource loadFromXML(String xml, ResourceSet rsSet) throws IOException {
        XMIResourceImpl res = new XMIResourceImpl();
        XMLHelperImpl xmlHelper = new XMLHelperImpl();
        ByteArrayInputStream stringreader = new ByteArrayInputStream(xml.getBytes());
        XMILoadImpl xmiload = new XMILoadImpl((XMLHelper)xmlHelper);
        xmiload.load((XMLResource)res, (InputStream)stringreader, Collections.EMPTY_MAP);
        if (res.getURI() == null) {
            res.setURI(URI.createURI((String)""));
        }
        return res;
    }

    public static Diagram getDiagramFromResource(Resource res) {
        for (Object o : res.getContents()) {
            if (!(o instanceof Diagram)) continue;
            return (Diagram)o;
        }
        return null;
    }

    public static boolean areSameObjects(EObject oldNode, EObject newNode) {
        String oldXMI;
        String newXMI = DawnResourceHelper.getXmiId(newNode);
        return newXMI.equals(oldXMI = DawnResourceHelper.getXmiId(oldNode));
    }

    public static EObject getSameEObjectFromOtherResource(EObject e, XMLResource resource) {
        String xmiId = DawnResourceHelper.getXmiId(e);
        EObject ret = resource.getEObject(xmiId);
        return ret;
    }

    public static boolean objectsHaveChanged(Object serverO, Object clientO) {
        if (serverO instanceof Node && clientO instanceof Node) {
            Node s = (Node)serverO;
            Node c = (Node)clientO;
            if (DawnResourceHelper.objectsHaveChanged(s.getLayoutConstraint(), c.getLayoutConstraint())) {
                return true;
            }
            if (DawnResourceHelper.objectsHaveChanged(s.getElement(), c.getElement())) {
                return true;
            }
        } else if (serverO instanceof Edge && clientO instanceof Edge) {
            Edge s = (Edge)serverO;
            Edge c = (Edge)clientO;
            RelativeBendpoints sr = (RelativeBendpoints)s.getBendpoints();
            RelativeBendpoints cr = (RelativeBendpoints)c.getBendpoints();
            if (sr.getPoints().size() != cr.getPoints().size()) {
                return true;
            }
            int i = 0;
            for (Object o : sr.getPoints()) {
                RelativeBendpoint cb;
                RelativeBendpoint sb = (RelativeBendpoint)o;
                if (DawnResourceHelper.objectsHaveChanged(sb, cb = (RelativeBendpoint)cr.getPoints().get(i))) {
                    return true;
                }
                ++i;
            }
        } else if (serverO instanceof RelativeBendpoint && clientO instanceof RelativeBendpoint) {
            RelativeBendpoint sb = (RelativeBendpoint)serverO;
            RelativeBendpoint cb = (RelativeBendpoint)clientO;
            if (sb.getSourceX() != cb.getSourceX()) {
                return true;
            }
            if (sb.getSourceY() != cb.getSourceY()) {
                return true;
            }
            if (sb.getTargetX() != cb.getTargetX()) {
                return true;
            }
            if (sb.getTargetY() != cb.getTargetY()) {
                return true;
            }
        } else if (serverO instanceof Bounds && clientO instanceof Bounds) {
            if (((Bounds)serverO).getX() != ((Bounds)clientO).getX()) {
                return true;
            }
            if (((Bounds)serverO).getY() != ((Bounds)clientO).getY()) {
                return true;
            }
            if (((Bounds)serverO).getWidth() != ((Bounds)clientO).getWidth()) {
                return true;
            }
            if (((Bounds)serverO).getHeight() != ((Bounds)clientO).getHeight()) {
                return true;
            }
        } else if (serverO instanceof EObject && clientO instanceof EObject) {
            EObject s = (EObject)serverO;
            EObject c = (EObject)clientO;
            for (EAttribute attribute : s.eClass().getEAllAttributes()) {
                Object co = c.eGet((EStructuralFeature)attribute);
                Object so = s.eGet((EStructuralFeature)attribute);
                if (co == null || so == null) {
                    return false;
                }
                if (co.equals(so)) continue;
                return true;
            }
            if (s.eContents().size() != c.eContents().size()) {
                return true;
            }
            int i = 0;
            for (EObject sChild : s.eContents()) {
                EObject cChild;
                if (DawnResourceHelper.objectsHaveChanged(sChild, cChild = (EObject)c.eContents().get(i))) {
                    return true;
                }
                ++i;
            }
        } else if (TRACER.isEnabled()) {
            TRACER.format("classes are not identical...no match {0} / {1}", new Object[]{serverO, clientO});
        }
        return false;
    }

    public static Resource loadResourceFromFileString(String filePath, ResourceSet rsSet) throws IOException {
        try {
            String s;
            File file = new File(filePath);
            FileReader reader = new FileReader(file);
            BufferedReader Ein = new BufferedReader(reader);
            StringBuffer buff = new StringBuffer();
            while ((s = Ein.readLine()) != null) {
                buff.append(s + System.getProperty("line.separator"));
            }
            Ein.close();
            Resource resource = DawnResourceHelper.loadFromXML(buff.toString(), rsSet);
            return resource;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readFromFile(String filePath) throws IOException {
        try {
            String s;
            File file = new File(filePath);
            FileReader reader = new FileReader(file);
            BufferedReader Ein = new BufferedReader(reader);
            StringBuffer buff = new StringBuffer();
            while ((s = Ein.readLine()) != null) {
                buff.append(s + System.getProperty("line.separator"));
            }
            Ein.close();
            return buff.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void copyXmiId(EObject oldElement, EObject newElement) {
        DawnResourceHelper.setXmiId(newElement, DawnResourceHelper.getXmiId(oldElement));
    }

    public static void setXmiId(EObject v, XMLResource oldResource) {
        DawnResourceHelper.setXmiId(v, DawnResourceHelper.getXmiId(v, (Resource)oldResource));
    }

    public static EObject createCopyAndInsert(EObject oldObject, EObject newParent) {
        EObject ret = EcoreUtil.copy((EObject)oldObject);
        EStructuralFeature containingFeature = oldObject.eContainingFeature();
        Object get = newParent.eGet(containingFeature);
        if (get instanceof Collection) {
            Collection list = (Collection)get;
            list.add(ret);
        } else {
            newParent.eSet(containingFeature, (Object)ret);
        }
        DawnResourceHelper.setXmiIdForChildren(oldObject, ret);
        return ret;
    }

    public static EObject createCopy(EObject v) {
        EObject ret = EcoreUtil.copy((EObject)v);
        return ret;
    }

    private static int setXmiIdForChildren(EObject oldChild, EObject newChild) {
        DawnResourceHelper.setXmiId(newChild, DawnResourceHelper.getXmiId(oldChild));
        int i = 0;
        for (EObject oldC : oldChild.eContents()) {
            EObject newC = (EObject)newChild.eContents().get(i);
            DawnResourceHelper.setXmiIdForChildren(oldC, newC);
            ++i;
        }
        return i;
    }

    public static void copyXmiIds(EObject oldObject, EObject newObject) {
        DawnResourceHelper.setXmiIdForChildren(oldObject, newObject);
    }

    @Deprecated
    public static void updateElement(EObject oldElement, EObject newElement) {
        if (oldElement == null) {
            newElement = oldElement;
            return;
        }
        for (EAttribute attribute : oldElement.eClass().getEAllAttributes()) {
            newElement.eSet((EStructuralFeature)attribute, oldElement.eGet((EStructuralFeature)attribute));
        }
    }

    public static void updateEObject(EObject leftObject, EObject rightObject) throws EClassIncompatibleException {
        if (rightObject == null) {
            DawnResourceHelper.removeEObjectFromParent(leftObject);
            return;
        }
        if (!leftObject.eClass().equals(rightObject.eClass())) {
            throw new EClassIncompatibleException(leftObject.eClass().getName() + "(" + DawnResourceHelper.getXmiId(leftObject) + ")/" + rightObject.eClass().getName() + "(" + DawnResourceHelper.getXmiId(leftObject) + ")");
        }
        DawnResourceHelper.updateEAttributes(leftObject, rightObject);
        DawnResourceHelper.updateEReferences(leftObject, rightObject);
        for (Object o : rightObject.eContents()) {
            EObject rightChild = (EObject)o;
            EObject leftChild = DawnResourceHelper.getSameEObjectFromOtherResource(rightChild, (XMLResource)leftObject.eResource());
            if (leftChild != null) {
                DawnResourceHelper.updateEObject(leftChild, rightChild);
                continue;
            }
            if (o instanceof View) {
                View childView = (View)o;
                EObject childViewElement = childView.getElement();
                View childViewCopy = (View)DawnResourceHelper.createCopyAndInsert(rightChild, leftObject);
                if (childViewElement != null) {
                    EObject childElementCopy = DawnResourceHelper.getSameEObjectFromOtherResource(childViewElement, (XMLResource)leftObject.eResource());
                    DawnResourceHelper.updateEObject(childElementCopy, childViewElement);
                    childViewCopy.setElement(childElementCopy);
                }
                DawnResourceHelper.updateEObject((EObject)childViewCopy, (EObject)childView);
                continue;
            }
            EObject childCopy = DawnResourceHelper.createCopyAndInsert(rightChild, leftObject);
            DawnResourceHelper.updateEObject(childCopy, rightChild);
        }
        ArrayList<EObject> tempDeletionList = new ArrayList<EObject>();
        for (Object e : leftObject.eContents()) {
            tempDeletionList.add((EObject)e);
        }
        for (EObject eObject : tempDeletionList) {
            EObject rightChild = DawnResourceHelper.getSameEObjectFromOtherResource(eObject, (XMLResource)rightObject.eResource());
            DawnResourceHelper.updateEObject(eObject, rightChild);
        }
    }

    private static void removeEObjectFromParent(EObject leftObject) {
        View view;
        if (leftObject instanceof View && (view = (View)leftObject).getElement() != null) {
            DawnResourceHelper.removeEObjectFromParent(view.getElement());
        }
        EObject parent = leftObject.eContainer();
        EStructuralFeature containingFeature = leftObject.eContainingFeature();
        if (parent != null) {
            Object container = parent.eGet(containingFeature);
            if (container instanceof Collection) {
                Collection collection = (Collection)container;
                collection.remove(leftObject);
            } else {
                parent.eSet(containingFeature, null);
            }
        } else if (TRACER.isEnabled()) {
            TRACER.format("arent is null, object ist still removed from parent : {0} ", new Object[]{leftObject});
        }
    }

    private static void updateEReferences(EObject leftObject, EObject rightObject) throws EClassIncompatibleException {
        for (EReference reference : rightObject.eClass().getEReferences()) {
            DawnResourceHelper.updateReference(leftObject, rightObject, reference);
        }
    }

    public static void updateReference(EObject leftParent, EObject rightParent, EReference reference) throws EClassIncompatibleException {
        if (reference.getName().equals("element")) {
            return;
        }
        Object leftReferenceObject = leftParent.eGet((EStructuralFeature)reference);
        Object rightReferenceObject = rightParent.eGet((EStructuralFeature)reference);
        if (leftReferenceObject != null) {
            if (leftReferenceObject instanceof Collection) {
                Collection leftCollection = (Collection)leftReferenceObject;
                Collection rightCollection = (Collection)rightReferenceObject;
                for (Object o : rightCollection) {
                    EObject rightCollectionChild = (EObject)o;
                    EObject leftCollectionChild = DawnResourceHelper.getSameEObjectFromOtherResource(rightCollectionChild, (XMLResource)leftParent.eResource());
                    if (leftCollectionChild == null) {
                        leftCollectionChild = DawnResourceHelper.createCopy(rightCollectionChild);
                        leftCollection.add(leftCollectionChild);
                        continue;
                    }
                    if (!rightCollectionChild.eResource().equals(leftParent.eResource())) {
                        leftCollection.remove(rightCollectionChild);
                        leftCollection.add(leftCollectionChild);
                    }
                    DawnResourceHelper.updateEObject(leftCollectionChild, rightCollectionChild);
                }
            } else {
                DawnResourceHelper.updateEObject((EObject)leftParent.eGet((EStructuralFeature)reference), (EObject)rightParent.eGet((EStructuralFeature)reference));
            }
        } else if (rightReferenceObject != null) {
            leftParent.eSet((EStructuralFeature)reference, (Object)EcoreUtil.copy((EObject)((EObject)rightReferenceObject)));
        }
    }

    private static void updateEAttributes(EObject leftObject, EObject rightObject) {
        for (EAttribute attribute : rightObject.eClass().getEAllAttributes()) {
            leftObject.eSet((EStructuralFeature)attribute, rightObject.eGet((EStructuralFeature)attribute));
        }
    }

    public static void deleteViewInResource(Resource resource, EObject e) {
        Diagram diagram = DawnResourceHelper.getDiagramFromResource(resource);
        EObject element = ((View)e).getElement();
        if (element != null) {
            DawnResourceHelper.removeElementFromContainer(element);
        }
        if (e instanceof Node) {
            View node = (View)e;
            diagram.removeChild(node);
            ArrayList toBeDeleted = new ArrayList(node.getSourceEdges());
            for (Object obj : toBeDeleted) {
                Edge edge = (Edge)obj;
                DawnResourceHelper.deleteViewInResource(resource, (EObject)edge);
            }
        } else if (e instanceof Edge) {
            Edge edge = (Edge)e;
            diagram.removeEdge(edge);
            edge.setSource(null);
            edge.setTarget(null);
        }
    }

    private static void removeElementFromContainer(EObject element) {
        EStructuralFeature containingFeature = element.eContainingFeature();
        EObject container = element.eContainer();
        if (container != null) {
            Object get = container.eGet(containingFeature);
            if (get instanceof Collection) {
                Collection list = (Collection)get;
                list.remove(element);
            } else {
                container.eSet(containingFeature, null);
            }
        }
    }

    public static void addElementToContainer(EObject element, EObject container, EStructuralFeature containingFeature) {
        Object get = container.eGet(containingFeature);
        if (get instanceof Collection) {
            Collection list = (Collection)get;
            list.add(element);
        } else {
            container.eSet(containingFeature, (Object)element);
        }
    }

    public static boolean isObjectInResource(Resource res, EObject element) {
        EObject object = res.getEObject(DawnResourceHelper.getXmiId(element));
        return object != null;
    }

    public static void printResource(Resource r) {
        for (EObject o : r.getContents()) {
            DawnResourceHelper.printEObjectFull(o, 0);
        }
    }

    public static void printEObject(EObject o, int level) {
        for (Object child : o.eContents()) {
            DawnResourceHelper.printEObject((EObject)child, level + 1);
        }
    }

    public static void printEObjectFull(EObject o, int level) {
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "--------------------------------------------");
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "Object: " + String.valueOf(o));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eContainer: " + String.valueOf(o.eContainer()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eContainingFeature: " + String.valueOf(o.eContainingFeature()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eContainmentFeature: " + String.valueOf(o.eContainmentFeature()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eIsProxy: " + o.eIsProxy());
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eResource: " + String.valueOf(o.eResource()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.getClass: " + String.valueOf(o.getClass()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass: " + String.valueOf(o.eClass()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eCrossReferences: " + String.valueOf(o.eCrossReferences()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getClassifierID: " + o.eClass().getClassifierID());
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getFeatureCount: " + o.eClass().getFeatureCount());
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getInstanceClassName: " + o.eClass().getInstanceClassName());
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getInstanceTypeName: " + o.eClass().getInstanceTypeName());
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getName: " + o.eClass().getName());
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getDefaultValue: " + String.valueOf(o.eClass().getDefaultValue()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getEPackage: " + String.valueOf(o.eClass().getEPackage()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getEIDAttribute: " + String.valueOf(o.eClass().getEIDAttribute()));
        DawnResourceHelper.print(DawnResourceHelper.tabs(level) + "o.eClass.getInstanceClass: " + String.valueOf(o.eClass().getInstanceClass()));
        for (EAttribute attribute : o.eClass().getEAllAttributes()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass.getEAllAttributes.attribute: '" + attribute.getName() + "': " + String.valueOf(o.eGet((EStructuralFeature)attribute)));
        }
        for (EAnnotation annotation : o.eClass().getEAnnotations()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAnnotations().annotation: '" + String.valueOf(annotation));
        }
        for (EReference containment : o.eClass().getEAllContainments()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAllContainments().containment: '" + String.valueOf(containment));
        }
        for (EGenericType genericSupertype : o.eClass().getEAllGenericSuperTypes()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAllGenericSuperTypes().genericSupertype: '" + String.valueOf(genericSupertype));
        }
        for (EOperation operation : o.eClass().getEAllOperations()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAllOperations().operation: '" + String.valueOf(operation));
        }
        for (EReference reference : o.eClass().getEAllReferences()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAllReferences().reference: '" + String.valueOf(reference));
        }
        for (EClass supertype : o.eClass().getEAllSuperTypes()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAllSuperTypes().supertype: '" + String.valueOf(supertype));
        }
        for (EStructuralFeature structuralFeature : o.eClass().getEAllStructuralFeatures()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAllStructuralFeatures().structuralFeature: '" + String.valueOf(structuralFeature));
        }
        for (EAnnotation annotation : o.eClass().getEAnnotations()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAnnotations().annotation: '" + String.valueOf(annotation));
        }
        for (EAttribute attribute : o.eClass().getEAttributes()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().getEAttributes().annotation: '" + String.valueOf(attribute));
        }
        for (Adapter adapter : o.eClass().eAdapters()) {
            DawnResourceHelper.print(DawnResourceHelper.tabs(level + 1) + "o.eClass().eAdapters().adapter: '" + String.valueOf(adapter));
        }
        for (Object child : o.eContents()) {
            DawnResourceHelper.printEObjectFull((EObject)child, level + 2);
        }
    }

    private static String tabs(int level) {
        Object s = "";
        int i = 0;
        while (i < level) {
            s = (String)s + "\t";
            ++i;
        }
        return s;
    }

    public static String getLocationFromResource(Resource r) throws MalformedURLException, IOException {
        return FileLocator.resolve((URL)new URL(r.getURI().toString())).toString().replace("file:", "");
    }

    @Deprecated
    public static EditPart findEditPartByXMIId(View view, DiagramDocumentEditor dawnDiagramEditor) {
        EditPart ep;
        DiagramEditPart diagramEditPart = dawnDiagramEditor.getDiagramEditPart();
        for (Object e : diagramEditPart.getChildren()) {
            ep = (EditPart)e;
            if (!DawnResourceHelper.getXmiId((EObject)ep.getModel()).equals(DawnResourceHelper.getXmiId((EObject)view))) continue;
            return ep;
        }
        for (Object e : diagramEditPart.getConnections()) {
            ep = (EditPart)e;
            if (!DawnResourceHelper.getXmiId((EObject)ep.getModel()).equals(DawnResourceHelper.getXmiId((EObject)view))) continue;
            return ep;
        }
        return null;
    }

    protected static void print(String s) {
        if (TRACER.isEnabled()) {
            TRACER.trace(s);
        }
    }
}

