/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse;

import java.io.File;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.IMenuButtonProvider;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.ProfilePathSelectionDialog;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.ProfileStoreBrowseButton;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.UIUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.profile.ProfileFileExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class MenuButtonProvider
implements IMenuButtonProvider {
    private static String BUTTON_BROWSE_TEXT = Messages.profilePage_button_browse;
    private static String RELATIVE_PATH_MENU = Messages.profilePage_button_relativepath;
    private static String ABSOLUTE_PATH_MENU = Messages.profilePage_button_absolutepath;
    private static String BUTTON_BROWSE_TOOLTIP_TEXT = Messages.profilePage_button_browse_tooltip;
    private static final String RELATIVE_PATH_TYPE = "RelativePath";
    private static final String ABSOLUTE_PATH_TYPE = "AbsolutePath";
    private static final String EXT_SEPARATOR = ".";
    private static final String FILE_DIALOG_FILTER_PREFIX = "*";
    private static final String FILE_DIALOG_FILTER_ALLOW_ALL = "*.*";
    private ProfileStoreBrowseButton button;
    private String[] optionTypes = new String[]{"AbsolutePath"};
    private boolean autoAppendSuffix;

    public MenuButtonProvider(boolean autoAppendSuffix) {
        this.autoAppendSuffix = autoAppendSuffix;
    }

    public String getDefaultOptionType() {
        return this.optionTypes == null || this.optionTypes.length == 0 ? null : this.optionTypes[0];
    }

    @Override
    public String[] getMenuItems() {
        return this.optionTypes;
    }

    @Override
    public Image getMenuItemImage(String type) {
        return null;
    }

    @Override
    public String getMenuItemText(String type) {
        if (RELATIVE_PATH_TYPE.equals(type)) {
            return RELATIVE_PATH_MENU;
        }
        return ABSOLUTE_PATH_MENU;
    }

    @Override
    public void handleSelectionEvent(String type) {
        Object value = this.getProperty("ResourceFileDIR");
        Object cpvalue = this.getProperty("IsCreateProfile");
        Object spvalue = this.getProperty("StoredPath");
        boolean isRelative = RELATIVE_PATH_TYPE.equals(type);
        String defaultExtension = ProfileFileExtension.getDefault();
        String[] fileNames = null;
        if (isRelative) {
            if (value != null && value instanceof File && cpvalue != null && cpvalue instanceof Boolean) {
                ProfilePathSelectionDialog dialog = new ProfilePathSelectionDialog(this.button.getControl().getShell(), (File)value, (Boolean)cpvalue, (String)spvalue, defaultExtension);
                if (dialog.open() == 0) {
                    fileNames = dialog.getSelectedItems();
                }
            } else {
                MessageBox box = new MessageBox(UIUtil.getDefaultShell(), 1);
                box.setText(Messages.ui_errorLabel);
                box.setMessage(Messages.profilePage_resourcebaseuri_failure);
                box.open();
            }
        } else {
            FileDialog dialog = new FileDialog(this.button.getControl().getShell());
            if (ProfileFileExtension.exists((String)defaultExtension)) {
                String[] filterExt = new String[]{"*." + defaultExtension, FILE_DIALOG_FILTER_ALLOW_ALL};
                dialog.setFilterExtensions(filterExt);
            }
            if (spvalue instanceof String) {
                dialog.setFileName((String)spvalue);
            }
            fileNames = new String[]{dialog.open()};
            String fileExtension = fileNames[0];
            if (this.autoAppendSuffix && fileExtension != null && fileExtension.trim().length() > 0 && !fileExtension.contains(EXT_SEPARATOR) && ProfileFileExtension.exists((String)defaultExtension)) {
                fileNames[0] = String.valueOf(fileExtension.trim()) + EXT_SEPARATOR + defaultExtension;
            }
        }
        if (fileNames != null && fileNames[0] != null) {
            this.button.handleSelection(fileNames[0], isRelative);
        }
    }

    @Override
    public void setInput(ProfileStoreBrowseButton input) {
        this.button = input;
    }

    public void resetProperties() {
        boolean supportsRelativePath = this.getProperty("ResourceFileDIR") instanceof File;
        this.optionTypes = supportsRelativePath ? new String[]{RELATIVE_PATH_TYPE, ABSOLUTE_PATH_TYPE} : new String[]{ABSOLUTE_PATH_TYPE};
    }

    @Override
    public String getButtonText() {
        return BUTTON_BROWSE_TEXT;
    }

    @Override
    public String getToolTipText() {
        return BUTTON_BROWSE_TOOLTIP_TEXT;
    }

    @Override
    public Object getProperty(String key) {
        return this.button.getControl().getData(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.button.getControl().setData(key, value);
    }
}

