/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaQuery;

public final class OdaSortSpecHelper {
    private OdaSortSpecHelper() {
    }

    public static void addSortKey(OdaQuery statement, String columnName, int sortOrder, String localeString) throws OdaException {
        OdaSortSpecHelper.addSortKey(statement, columnName, sortOrder);
    }

    public static void addSortKey(OdaQuery query, String columnName, int sortOrder) throws OdaException {
        SortSpec sortSpec = query.getSortSpec();
        if (sortSpec != null) {
            sortSpec.addSortKey(columnName, sortOrder);
            return;
        }
        int sortMode = query.getDSMetaData().getSortMode();
        sortSpec = new SortSpec(sortMode);
        sortSpec.addSortKey(columnName, sortOrder);
        query.setSortSpec(sortSpec);
    }

    public static void addSortKey(OdaAdvancedQuery statement, String resultSetName, String columnName, int sortOrder, String localeString) throws OdaException {
        OdaSortSpecHelper.addSortKey(statement, resultSetName, columnName, sortOrder);
    }

    public static void addSortKey(OdaAdvancedQuery query, String resultSetName, String columnName, int sortOrder) throws OdaException {
        SortSpec sortSpec = query.getSortSpec(resultSetName);
        if (sortSpec != null) {
            sortSpec.addSortKey(columnName, sortOrder);
            return;
        }
        int sortMode = query.getDSMetaData().getSortMode();
        sortSpec = new SortSpec(sortMode);
        sortSpec.addSortKey(columnName, sortOrder);
        query.setSortSpec(resultSetName, sortSpec);
    }

    public static void resetSortKeys(OdaQuery statement) throws OdaException {
        statement.setSortSpec(null);
    }

    public static void resetSortKeys(OdaAdvancedQuery statement, String resultSetName) throws OdaException {
        statement.setSortSpec(resultSetName, null);
    }
}

