/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LibraryRefContainer
extends CElementGrouping {
    private Object[] EMPTY = new Object[0];
    private ICProject fCProject;

    public LibraryRefContainer(ICProject cproject) {
        super(4096);
        this.fCProject = cproject;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return (T)((Object)this);
        }
        if (adapter == ICProject.class) {
            return (T)this.fCProject;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        try {
            ILibraryReference[] references = this.fCProject.getLibraryReferences();
            ArrayList<ILibraryReference> list = new ArrayList<ILibraryReference>(references.length);
            ILibraryReference[] iLibraryReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ILibraryReference reference = iLibraryReferenceArray[n2];
                IPath path = reference.getPath();
                IFile file = reference.getCModel().getWorkspace().getRoot().getFileForLocation(path);
                if (file == null || !file.isAccessible()) {
                    list.add(reference);
                }
                ++n2;
            }
            return list.toArray();
        }
        catch (CModelException cModelException) {
            return this.EMPTY;
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return CDTSharedImages.getImageDescriptor("icons/obj16/lib_obj.gif");
    }

    @Override
    public String getLabel(Object o) {
        return CViewMessages.LibraryRefContainer_Libraries;
    }

    public Object getParent(Object o) {
        return this.getCProject();
    }

    public ICProject getCProject() {
        return this.fCProject;
    }
}

