/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.xtext.common.types.ui.refactoring.JvmRenameRefactoringProvider;
import org.eclipse.xtext.common.types.ui.refactoring.participant.TextChangeCombiner;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.JvmModelJdtRenameParticipantContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.ChangeCombiningRenameRefactoring;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.CombinedJvmJdtRenameContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.CombinedJvmJdtRenameProcessor;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.JdtRenameRefactoringParticipantProcessor;

public class CombinedJvmJdtRenameRefactoringProvider
extends JvmRenameRefactoringProvider {
    @Inject
    private Provider<CombinedJvmJdtRenameProcessor> combinedRenameProcessorProvider;
    @Inject
    private Provider<JdtRenameRefactoringParticipantProcessor> jdtRenameParticipantProcessorProvider;
    @Inject
    private TextChangeCombiner textChangeCombiner;

    public ProcessorBasedRefactoring getRenameRefactoring(IRenameElementContext renameElementContext) {
        if (renameElementContext instanceof CombinedJvmJdtRenameContext) {
            RenameProcessor renameProcessor = this.getRenameProcessor(renameElementContext);
            if (renameProcessor != null) {
                return this.createChangeCombiningRefactoring(renameProcessor);
            }
            return null;
        }
        return super.getRenameRefactoring(renameElementContext);
    }

    public RenameProcessor getRenameProcessor(IRenameElementContext renameElementContext) {
        RenameElementProcessor processor = null;
        if (renameElementContext instanceof JvmModelJdtRenameParticipantContext) {
            processor = (RenameElementProcessor)this.jdtRenameParticipantProcessorProvider.get();
        } else if (renameElementContext instanceof CombinedJvmJdtRenameContext) {
            processor = (RenameElementProcessor)this.combinedRenameProcessorProvider.get();
        }
        if (processor != null) {
            if (processor.initialize(renameElementContext)) {
                return processor;
            }
            return null;
        }
        return super.getRenameProcessor(renameElementContext);
    }

    protected ProcessorBasedRefactoring createChangeCombiningRefactoring(RenameProcessor renameProcessor) {
        return new ChangeCombiningRenameRefactoring((RefactoringProcessor)renameProcessor, this.textChangeCombiner);
    }
}

