/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.launcher;

import java.util.ArrayList;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.ChromiumRemoteTab;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.ScriptMappingTab;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.WipRemoteTab;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public abstract class LaunchTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.setTabs((ILaunchConfigurationTab[])BasicUtil.toArray(this.createTabList(dialog, mode), ILaunchConfigurationTab.class));
    }

    protected ArrayList<ILaunchConfigurationTab> createTabList(ILaunchConfigurationDialog dialog, String mode) {
        ArrayList<ILaunchConfigurationTab> result = new ArrayList<ILaunchConfigurationTab>(4);
        ChromiumRemoteTab<?> remoteTab = this.createRemoteTab();
        result.add((ILaunchConfigurationTab)remoteTab);
        result.add((ILaunchConfigurationTab)new SourceLookupTab());
        result.add((ILaunchConfigurationTab)new ScriptMappingTab((Params)remoteTab.getParams()));
        result.add((ILaunchConfigurationTab)new CommonTab());
        return result;
    }

    protected abstract ChromiumRemoteTab<?> createRemoteTab();

    static class Params {
        private final ChromiumRemoteTab.HostChecker hostChecker;
        private final String scriptNameDescription;
        private final boolean enableSourceWrapper;

        Params(ChromiumRemoteTab.HostChecker hostChecker, String scriptNameDescription, boolean enableSourceWrapper) {
            this.hostChecker = hostChecker;
            this.scriptNameDescription = scriptNameDescription;
            this.enableSourceWrapper = enableSourceWrapper;
        }

        ChromiumRemoteTab.HostChecker getHostChecker() {
            return this.hostChecker;
        }

        String getScriptNameDescription() {
            return this.scriptNameDescription;
        }

        boolean preEnableSourceWrapper() {
            return this.enableSourceWrapper;
        }
    }

    public static class StandaloneV8
    extends LaunchTabGroup {
        @Override
        protected ChromiumRemoteTab<?> createRemoteTab() {
            return new ChromiumRemoteTab.Standalone();
        }
    }

    public static class Wip
    extends LaunchTabGroup {
        @Override
        protected ChromiumRemoteTab<?> createRemoteTab() {
            return new WipRemoteTab();
        }
    }
}

