/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.wst.dtd.core.internal.emf.DTDContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDEnumerationType;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDNotation;
import org.eclipse.wst.dtd.core.internal.emf.DTDObject;
import org.eclipse.wst.dtd.core.internal.emf.DTDPackage;
import org.eclipse.wst.dtd.core.internal.emf.DTDParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.emf.DTDSourceOffset;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDPathnameUtil;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDPrinter;

public class DTDFileImpl
extends ENamedElementImpl
implements DTDFile,
ENamedElement {
    protected static final String COMMENT_EDEFAULT = null;
    protected String comment = COMMENT_EDEFAULT;
    protected static final boolean PARSE_ERROR_EDEFAULT = false;
    protected boolean parseError = false;
    protected EList dtdContent;
    protected EList dtdEnumerationType;

    @Override
    public EList getDTDObject() {
        return this.getDTDContent();
    }

    @Override
    public List listDTDElement() {
        return this.getContentListOf(DTDElement.class, null);
    }

    @Override
    public List listDTDNotation() {
        return this.getContentListOf(DTDNotation.class, null);
    }

    @Override
    public List listDTDEntity() {
        return this.getContentListOf(DTDEntity.class, null);
    }

    @Override
    public List listDTDParameterEntityReference() {
        return this.getContentListOf(DTDParameterEntityReference.class, null);
    }

    @Override
    public List listDTDElementAndDTDParameterEntityReference() {
        return this.getContentListOf(DTDElement.class, DTDParameterEntityReference.class);
    }

    private List getContentListOf(Class class1, Class class2) {
        ArrayList v = new ArrayList();
        for (Object obj : this.getDTDContent()) {
            if (class1.isInstance(obj)) {
                v.add(obj);
                continue;
            }
            if (class2 == null || !class2.isInstance(obj)) continue;
            v.add(obj);
        }
        return v;
    }

    @Override
    public DTDElement findElement(String name) {
        for (DTDElement e : this.listDTDElement()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public DTDEntity findEntity(String name) {
        for (DTDEntity e : this.listDTDEntity()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public DTDNotation findNotation(String name) {
        for (DTDNotation e : this.listDTDNotation()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public DTDParameterEntityReference findParameterEntityReference(String name) {
        for (DTDParameterEntityReference e : this.listDTDParameterEntityReference()) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    @Override
    public String unparse(boolean include) {
        DTDPrinter printer = new DTDPrinter(true);
        printer.visitDTDFile(this);
        return printer.getBuffer().toString();
    }

    @Override
    public String getPathname() {
        return "";
    }

    @Override
    public DTDObject findObject(String relativePath) {
        Object[] result = DTDPathnameUtil.parsePathComponent(relativePath);
        String type = (String)result[0];
        if (type == null) {
            return null;
        }
        String name = (String)result[1];
        DTDSourceOffset obj = null;
        if (type.equals("Elem")) {
            obj = this.findElement(name);
        } else if (type.equals("Ent")) {
            obj = this.findEntity(name);
        } else if (type.equals("PEnt")) {
            obj = this.findParameterEntityReference(name);
        } else if (type.equals("Nota")) {
            obj = this.findNotation(name);
        } else {
            return null;
        }
        String restPath = (String)result[3];
        if (restPath == null || obj == null) {
            return obj;
        }
        return obj.findObject(restPath);
    }

    protected DTDFileImpl() {
    }

    protected EClass eStaticClass() {
        return DTDPackage.Literals.DTD_FILE;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldComment, (Object)this.comment));
        }
    }

    @Override
    public boolean isParseError() {
        return this.parseError;
    }

    @Override
    public void setParseError(boolean newParseError) {
        boolean oldParseError = this.parseError;
        this.parseError = newParseError;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldParseError, this.parseError));
        }
    }

    @Override
    public EList getDTDContent() {
        if (this.dtdContent == null) {
            this.dtdContent = new EObjectContainmentWithInverseEList(DTDContent.class, (InternalEObject)this, 2, 0);
        }
        return this.dtdContent;
    }

    @Override
    public EList getDTDEnumerationType() {
        if (this.dtdEnumerationType == null) {
            this.dtdEnumerationType = new EObjectContainmentWithInverseEList(DTDEnumerationType.class, (InternalEObject)this, 3, 11);
        }
        return this.dtdEnumerationType;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getDTDContent()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getDTDEnumerationType()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getDTDContent()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getDTDEnumerationType()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getComment();
            }
            case 1: {
                return this.isParseError() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.getDTDContent();
            }
            case 3: {
                return this.getDTDEnumerationType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setComment((String)newValue);
                return;
            }
            case 1: {
                this.setParseError((Boolean)newValue);
                return;
            }
            case 2: {
                this.getDTDContent().clear();
                this.getDTDContent().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getDTDEnumerationType().clear();
                this.getDTDEnumerationType().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setComment(COMMENT_EDEFAULT);
                return;
            }
            case 1: {
                this.setParseError(false);
                return;
            }
            case 2: {
                this.getDTDContent().clear();
                return;
            }
            case 3: {
                this.getDTDEnumerationType().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return COMMENT_EDEFAULT == null ? this.comment != null : !COMMENT_EDEFAULT.equals(this.comment);
            }
            case 1: {
                return this.parseError;
            }
            case 2: {
                return this.dtdContent != null && !this.dtdContent.isEmpty();
            }
            case 3: {
                return this.dtdEnumerationType != null && !this.dtdEnumerationType.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (comment: ");
        result.append(this.comment);
        result.append(", parseError: ");
        result.append(this.parseError);
        result.append(')');
        return result.toString();
    }
}

