/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.factory;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.util.factory.FactoryApplyAction;
import org.eclipse.wb.internal.core.model.util.factory.FactoryCreateAction;
import org.eclipse.wb.internal.core.model.util.factory.FactorySelectAction;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.MenuManagerEx;

public final class FactoryActionsSupport {
    private final JavaInfo m_component;
    private final AstEditor m_editor;
    private static final QualifiedName KEY_PREVIOUS_FACTORIES = new QualifiedName("org.eclipse.wb.core", "previousFactoryTypes");
    private static final int MAX_PREVIOUS_FACTORIES = 5;

    public static void contribute(JavaInfo component, IContributionManager manager) throws Exception {
        if (!(component.getCreationSupport() instanceof ConstructorCreationSupport)) {
            return;
        }
        MenuManagerEx factoryManager = new MenuManagerEx(ModelMessages.FactoryActionsSupport_factoryManager);
        factoryManager.setImage(DesignerPlugin.getImage((String)"actions/factory/factory.png"));
        manager.appendToGroup("org.eclipse.wb.popup.group.inheritance", (IContributionItem)factoryManager);
        new FactoryActionsSupport(component).contribute((IContributionManager)factoryManager);
    }

    private FactoryActionsSupport(JavaInfo component) {
        this.m_component = component;
        this.m_editor = this.m_component.getEditor();
    }

    private void contribute(IContributionManager manager) throws Exception {
        String[] previousTypeNames;
        IPackageFragment currentPackage = (IPackageFragment)this.m_editor.getModelUnit().getParent();
        List<ICompilationUnit> factoryUnits = FactoryDescriptionHelper.getFactoryUnits(this.m_editor, currentPackage);
        for (ICompilationUnit unit : factoryUnits) {
            String typeName = unit.findPrimaryType().getFullyQualifiedName();
            this.addApplyActions(manager, typeName);
        }
        manager.add((IContributionItem)new Separator());
        String[] stringArray = previousTypeNames = FactoryActionsSupport.getPreviousTypeNames(this.m_component);
        int n = previousTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            if (this.m_editor.getJavaProject().findType(typeName) != null) {
                this.addApplyActions(manager, typeName);
            }
            ++n2;
        }
        manager.add((IAction)new FactorySelectAction(this.m_component));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new FactoryCreateAction(this.m_component));
    }

    private void addApplyActions(IContributionManager manager, String typeName) throws Exception {
        ClassLoader classLoader = EditorState.get(this.m_editor).getEditorLoader();
        Class<?> factoryClass = classLoader.loadClass(typeName);
        Collection<FactoryMethodDescription> descriptions = FactoryDescriptionHelper.getDescriptionsMap(this.m_editor, factoryClass, true).values();
        for (FactoryMethodDescription description : descriptions) {
            Class<?> componentClass = this.m_component.getDescription().getComponentClass();
            if (!componentClass.isAssignableFrom(description.getReturnClass())) continue;
            manager.add((IAction)new FactoryApplyAction(this.m_component, description));
        }
    }

    static void clearPreviousTypeNames(JavaInfo component) throws CoreException {
        IProject project = component.getEditor().getJavaProject().getProject();
        project.setPersistentProperty(KEY_PREVIOUS_FACTORIES, null);
    }

    static String[] getPreviousTypeNames(JavaInfo component) throws CoreException {
        IProject project = component.getEditor().getJavaProject().getProject();
        String possiblePreviousTypeNames = project.getPersistentProperty(KEY_PREVIOUS_FACTORIES);
        if (possiblePreviousTypeNames != null) {
            return StringUtils.split((String)possiblePreviousTypeNames, (char)',');
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    static void addPreviousTypeName(JavaInfo component, String typeName) throws CoreException {
        Object[] typeNames = FactoryActionsSupport.getPreviousTypeNames(component);
        typeNames = (String[])ArrayUtils.removeElement((Object[])typeNames, (Object)typeName);
        if ((typeNames = (String[])ArrayUtils.insert((int)0, (Object[])typeNames, (Object[])new String[]{typeName})).length > 5) {
            typeNames = (String[])ArrayUtils.remove((Object[])typeNames, (int)(typeNames.length - 1));
        }
        IProject project = component.getEditor().getJavaProject().getProject();
        project.setPersistentProperty(KEY_PREVIOUS_FACTORIES, StringUtils.join((Object[])typeNames, (char)','));
    }
}

