/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class MethodsOperationRule
implements FailableBiConsumer<ComponentDescription, String, Exception> {
    private final boolean m_include;
    private ComponentDescription m_componentDescription;

    public MethodsOperationRule(boolean include) {
        this.m_include = include;
    }

    public void accept(ComponentDescription componentDescription, String signature) throws Exception {
        this.m_componentDescription = componentDescription;
        if (this.isRegexpSignature(signature)) {
            this.processRegexp(signature);
        } else {
            this.processSingleSignature(signature);
        }
    }

    private boolean isRegexpSignature(String signature) {
        return signature.startsWith("/") && signature.endsWith("/");
    }

    private void processRegexp(String signature) throws Exception {
        Pattern pattern = Pattern.compile(StringUtils.substring((String)signature, (int)1, (int)-1));
        this.process(t -> pattern.matcher((CharSequence)t).matches());
    }

    private void processSingleSignature(String signature) throws Exception {
        this.process(t -> signature.equals(t));
    }

    private void process(Predicate<String> signaturePredicate) throws Exception {
        if (this.m_include) {
            this.processInclude(signaturePredicate);
        } else {
            this.processExclude(signaturePredicate);
        }
    }

    private void processInclude(Predicate<String> signaturePredicate) throws Exception {
        Method[] methods;
        Method[] methodArray = methods = this.m_componentDescription.getComponentClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodSignature = ReflectionUtils.getMethodSignature((Method)method);
            if (signaturePredicate.test(methodSignature)) {
                this.m_componentDescription.addMethod(method);
            }
            ++n2;
        }
    }

    private void processExclude(Predicate<String> signaturePredicate) {
        Iterator<MethodDescription> I = this.m_componentDescription.getMethods().iterator();
        while (I.hasNext()) {
            MethodDescription methodDescription = I.next();
            String methodSignature = methodDescription.getSignature();
            if (!signaturePredicate.test(methodSignature)) continue;
            I.remove();
        }
    }
}

