/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.assist;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.editor.tools.internal.assist.TypeAssistant;
import org.eclipse.sirius.editor.tools.internal.assist.TypeContentProposal;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.ui.tools.api.assist.TextContentProposalProvider;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CreateInstanceTypeContentProposalProvider
extends TextContentProposalProvider {
    private final TypeAssistant assistant;

    public CreateInstanceTypeContentProposalProvider(TypeAssistant assistant) {
        this.assistant = assistant;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        IInterpreterContext interpreterContext = this.createInterpretedContext();
        String incompleteText = contents.substring(0, position);
        List<EClassifier> proposals = this.assistant.proposal(incompleteText);
        Collection<EClass> superTypes = this.getPotentialSuperTypes(interpreterContext);
        if (!superTypes.isEmpty()) {
            Iterator<EClassifier> iterator = proposals.iterator();
            while (iterator.hasNext()) {
                EClassifier next = iterator.next();
                Optional<EClassifier> optionalEClassifier = Optional.of(next).filter(EClass.class::isInstance).filter(eClass -> {
                    for (EClass superType : superTypes) {
                        if (!superType.isSuperTypeOf((EClass)eClass)) continue;
                        return true;
                    }
                    return false;
                });
                if (optionalEClassifier.isPresent()) continue;
                iterator.remove();
            }
        }
        IContentProposal[] result = new IContentProposal[proposals.size()];
        int i = 0;
        while (i < proposals.size()) {
            TypeContentProposal newProposal = new TypeContentProposal(proposals.get(i), incompleteText);
            result[i] = newProposal;
            ++i;
        }
        return result;
    }

    private IInterpreterContext createInterpretedContext() {
        Object selectedElement = this.getSelectedElement();
        EAttribute f = ToolPackage.eINSTANCE.getCreateInstance_ReferenceName();
        return SiriusInterpreterContextFactory.createInterpreterContext((EObject)((EObject)selectedElement), (EStructuralFeature)f);
    }

    private Collection<EClass> getPotentialSuperTypes(IInterpreterContext interpreterContext) {
        String referenceName = ((CreateInstance)interpreterContext.getElement()).getReferenceName();
        if (!StringUtil.isEmpty((String)referenceName)) {
            return interpreterContext.getTargetType().getPossibleTypes().stream().flatMap(type -> type.search(interpreterContext.getAvailableEPackages()).stream()).filter(EClass.class::isInstance).flatMap(eClass -> ((EClass)eClass).getEAllStructuralFeatures().stream()).filter(eStructuralFeature -> eStructuralFeature.getName().equals(referenceName) && eStructuralFeature.getEType() instanceof EClass).map(eStructuralFeature -> (EClass)eStructuralFeature.getEType()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

