/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.derived;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.s.derived.DtoUpdateHandler;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceHandler;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.derived.DerivedResourceInputWithJdt;
import org.eclipse.scout.sdk.s2e.derived.IDerivedResourceHandlerFactory;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class DtoDerivedResourceHandlerFactory
implements IDerivedResourceHandlerFactory {
    @Override
    public List<IDerivedResourceHandler> createHandlersFor(Set<IResource> resources, IJavaSearchScope searchScope) throws JavaModelException {
        HashSet<IType> baseTypes = new HashSet<IType>();
        DtoDerivedResourceHandlerFactory.findScopeCandidates(searchScope, baseTypes);
        DtoDerivedResourceHandlerFactory.findResourceCandidates(resources, baseTypes);
        if (baseTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return baseTypes.stream().map(DerivedResourceInputWithJdt::new).map(DtoUpdateHandler::new).collect(Collectors.toList());
    }

    protected static void findResourceCandidates(Iterable<IResource> resources, Collection<IType> collector) throws JavaModelException {
        for (IResource r : resources) {
            ICompilationUnit icu;
            Optional<IScoutApi> api;
            IJavaElement javaElement = JavaCore.create((IResource)r);
            if (!JdtUtils.exists(javaElement) || javaElement.getElementType() != 5 || !(api = ApiHelper.scoutApiFor((icu = (ICompilationUnit)javaElement).getJavaProject())).isPresent()) continue;
            String[] dtoNames = DtoDerivedResourceHandlerFactory.dtoMarkerAnnotationNames((IScoutAnnotationApi)api.orElseThrow());
            for (IType candidate : icu.getTypes()) {
                if (!DtoDerivedResourceHandlerFactory.acceptType(candidate) || !JdtUtils.exists((IJavaElement)JdtUtils.getFirstAnnotationInSupertypeHierarchy(candidate, dtoNames))) continue;
                collector.add(candidate);
            }
        }
    }

    protected static String[] dtoMarkerAnnotationNames(IScoutAnnotationApi scoutApi) {
        return new String[]{scoutApi.FormData().fqn(), scoutApi.PageData().fqn(), scoutApi.Data().fqn()};
    }

    protected static void findScopeCandidates(IJavaSearchScope scope, Collection<IType> collector) {
        if (scope == null) {
            return;
        }
        ScoutApi.allKnown().map(DtoDerivedResourceHandlerFactory::dtoMarkerAnnotationNames).flatMap(Stream::of).distinct().flatMap(fqn -> JdtUtils.findAllTypesAnnotatedWith(fqn, scope, null).stream()).filter(DtoDerivedResourceHandlerFactory::acceptType).forEach(collector::add);
    }

    protected static boolean acceptType(IType jdtType) {
        if (!JdtUtils.exists((IJavaElement)jdtType) || !JdtUtils.exists((IJavaElement)jdtType.getJavaProject()) || jdtType.isBinary() || jdtType.getDeclaringType() != null) {
            return false;
        }
        try {
            return !jdtType.isAnonymous() && Flags.isPublic((int)jdtType.getFlags());
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }
}

