/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.PHPExeException;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PHPExeCompositeFragment
extends CompositeFragment
implements IPHPExeCompositeFragment {
    private static final String PHP_INI = "php.ini";
    private PHPexeItem[] existingItems;
    private StringDialogField fPHPexeName;
    private StringButtonDialogField fPHPExePath;
    private StringButtonDialogField fPHPIni;
    private Button fLoadDefaultPHPIni;
    private Label fSapiTypesLabel;
    private Combo fSapiTypes;
    private Label fVersionLabel;
    private String initialName;
    private boolean isIniFileSet = false;

    public PHPExeCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.createDescription();
    }

    protected void createDescription() {
        this.setDisplayName(PHPDebugUIMessages.PHPExeCompositeFragment_2);
        this.setDescription(PHPDebugUIMessages.PHPExeCompositeFragment_0);
        this.controlHandler.setDescription(this.getDescription());
        this.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_PHPEXE"));
        this.controlHandler.setImageDescriptor(this.getImageDescriptor());
        switch (this.controlHandler.getKind()) {
            case WIZARD: {
                this.setTitle(PHPDebugUIMessages.PHPExeCompositeFragment_10);
                break;
            }
            case EDITOR: {
                this.setTitle(PHPDebugUIMessages.PHPExeCompositeFragment_11);
                break;
            }
        }
        this.controlHandler.setTitle(this.getTitle());
    }

    protected String getPHPexeName() {
        return this.fPHPexeName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fPHPExePath.getText());
    }

    protected File getIniLocation() {
        return new File(this.fPHPIni.getText());
    }

    protected void createContents(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite settingsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        settingsComposite.setLayout((Layout)layout);
        settingsComposite.setLayoutData((Object)new GridData(1808));
        this.fPHPexeName = new StringDialogField();
        this.fPHPexeName.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpName);
        this.fPHPExePath = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                FileDialog dialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                dialog.setFilterPath(PHPExeCompositeFragment.this.fPHPExePath.getText());
                dialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPRootDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    PHPExeCompositeFragment.this.fPHPExePath.setText(newPath);
                }
            }
        });
        this.fPHPExePath.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpHome);
        this.fPHPExePath.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPIni = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                FileDialog dialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                dialog.setFilterPath(PHPExeCompositeFragment.this.fPHPIni.getText());
                dialog.setFilterExtensions(new String[]{"*.ini", "*.*"});
                dialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPIniDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    PHPExeCompositeFragment.this.fPHPIni.setText(newPath);
                    PHPExeCompositeFragment.this.isIniFileSet = true;
                }
            }
        });
        this.fPHPIni.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpIni);
        this.fPHPIni.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPexeName.doFillIntoGrid(settingsComposite, 3);
        this.fPHPExePath.doFillIntoGrid(settingsComposite, 3);
        ((GridData)this.fPHPExePath.getTextControl((Composite)settingsComposite).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fPHPIni.doFillIntoGrid(settingsComposite, 3);
        ((GridData)this.fPHPIni.getTextControl((Composite)settingsComposite).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fLoadDefaultPHPIni = new Button(settingsComposite, 32);
        this.fLoadDefaultPHPIni.setText(PHPDebugUIMessages.addPHPexeDialog_loadDefaultPHPIni);
        GridData loadDefaultPHPIniData = new GridData(4);
        loadDefaultPHPIniData.horizontalSpan = 3;
        this.fLoadDefaultPHPIni.setLayoutData((Object)loadDefaultPHPIniData);
        this.fSapiTypesLabel = new Label(settingsComposite, 16448);
        this.fSapiTypesLabel.setFont(settingsComposite.getFont());
        this.fSapiTypesLabel.setText(PHPDebugUIMessages.PHPExeCompositeFragment_1);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        this.fSapiTypesLabel.setLayoutData((Object)data);
        this.fSapiTypes = new Combo(settingsComposite, 12);
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.fSapiTypes.setLayoutData((Object)data);
        this.fSapiTypes.add("CLI");
        this.fSapiTypes.add("CGI");
        Label versionLabel = new Label(settingsComposite, 16448);
        versionLabel.setFont(settingsComposite.getFont());
        versionLabel.setText("Version: ");
        data = new GridData();
        data.horizontalSpan = 1;
        versionLabel.setLayoutData((Object)data);
        this.fVersionLabel = new Label(settingsComposite, 16448);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 100;
        data.grabExcessHorizontalSpace = true;
        this.fVersionLabel.setLayoutData((Object)data);
        this.fVersionLabel.setText("");
        this.init();
        this.createFieldListeners();
        Dialog.applyDialogFont((Control)this);
    }

    protected void createFieldListeners() {
        this.fPHPexeName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fPHPExePath.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                String newPath = PHPExeCompositeFragment.this.fPHPExePath.getText();
                if (newPath != null && newPath.trim().length() > 0) {
                    File executable;
                    PHPExeUtil.PHPExeInfo phpExecInfo;
                    if (!PHPExeCompositeFragment.this.isIniFileSet || PHPExeCompositeFragment.this.fPHPIni.getText() == null || PHPExeCompositeFragment.this.fPHPIni.getText().trim().length() == 0) {
                        Path path = new Path(newPath);
                        path = path.removeLastSegments(1);
                        if ((path = path.append(PHPExeCompositeFragment.PHP_INI)).toFile().exists()) {
                            PHPExeCompositeFragment.this.fPHPIni.setTextWithoutUpdate(path.toOSString());
                        }
                    }
                    if ((phpExecInfo = PHPExeCompositeFragment.this.getPHPInfo(executable = new File(newPath))) != null) {
                        if (PHPExeCompositeFragment.this.fPHPexeName.getText().isEmpty() && phpExecInfo.getName() != null) {
                            PHPExeCompositeFragment.this.fPHPexeName.setTextWithoutUpdate(phpExecInfo.getName());
                        }
                        if (phpExecInfo.getSapiType() != null) {
                            PHPExeCompositeFragment.this.fSapiTypes.setText(phpExecInfo.getSapiType());
                        }
                        if (phpExecInfo.getVersion() != null) {
                            PHPExeCompositeFragment.this.fVersionLabel.setText(phpExecInfo.getVersion());
                        }
                    } else {
                        PHPExeCompositeFragment.this.fSapiTypes.deselectAll();
                        PHPExeCompositeFragment.this.fVersionLabel.setText("");
                    }
                }
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fPHPIni.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fLoadDefaultPHPIni.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
        this.fSapiTypes.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }

            public void widgetSelected(SelectionEvent e) {
                PHPExeCompositeFragment.this.updateItem();
            }
        });
    }

    protected void init() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem == null || phpExeItem.getName() == null) {
            this.fPHPexeName.setTextWithoutUpdate("");
            this.fPHPExePath.setTextWithoutUpdate("");
            this.fPHPIni.setTextWithoutUpdate("");
        } else {
            this.initialName = phpExeItem.getName();
            this.fPHPexeName.setTextWithoutUpdate(phpExeItem.getName());
            this.fPHPexeName.setEnabled(phpExeItem.isEditable());
            this.fPHPExePath.setTextWithoutUpdate(phpExeItem.getExecutable().getAbsolutePath());
            this.fPHPExePath.setEnabled(phpExeItem.isEditable());
            if (phpExeItem.getINILocation() != null) {
                this.fPHPIni.setTextWithoutUpdate(phpExeItem.getINILocation().toString());
            }
            this.fPHPIni.setEnabled(phpExeItem.isEditable());
            this.fLoadDefaultPHPIni.setEnabled(phpExeItem.isEditable());
            this.fLoadDefaultPHPIni.setSelection(phpExeItem.isLoadDefaultINI());
            String sapiType = phpExeItem.getSapiType();
            if (sapiType != null) {
                this.fSapiTypes.setText(sapiType);
            }
            this.fSapiTypes.setEnabled(phpExeItem.isEditable());
            this.fSapiTypesLabel.setEnabled(phpExeItem.isEditable());
            this.fVersionLabel.setText(phpExeItem.getVersion());
        }
        this.updateItem();
    }

    @Override
    public void setExistingItems(PHPexeItem[] existingItems) {
        this.existingItems = existingItems;
    }

    public void setData(Object data) {
        if (data != null && !(data instanceof PHPexeItem)) {
            throw new IllegalArgumentException(PHPDebugUIMessages.PHPExeCompositeFragment_3);
        }
        super.setData(data);
        this.init();
        this.fPHPExePath.getChangeControl(null).setFocus();
    }

    public void validate() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        this.setComplete(true);
        this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_0, 1);
        if (phpExeItem.getExecutable() == null || phpExeItem.getExecutable().getPath().length() == 0) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterLocation, 1);
            this.setComplete(false);
            return;
        }
        if (phpExeItem.getName().isEmpty()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterName, 1);
            this.setComplete(false);
            return;
        }
        if (phpExeItem.getExecutable() == null) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_13, 3);
            return;
        }
        if (!phpExeItem.getExecutable().exists()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_locationNotExists, 3);
            return;
        }
        PHPExeUtil.PHPExeInfo phpExecInfo = this.getPHPInfo(phpExeItem.getExecutable());
        if (phpExecInfo == null) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_13, 3);
            return;
        }
        if (this.existingItems != null) {
            PHPexeItem[] pHPexeItemArray = this.existingItems;
            int n = this.existingItems.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (!item.getName().equals(this.initialName) && item.getName().equals(phpExeItem.getName())) {
                    this.setMessage(PHPDebugUIMessages.addPHPexeDialog_duplicateName, 3);
                    return;
                }
                ++n2;
            }
        }
        if (phpExeItem.getSapiType().isEmpty()) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_15, 3);
            return;
        }
        if (phpExecInfo.getSapiType() != null && !phpExeItem.getSapiType().equals(phpExecInfo.getSapiType())) {
            this.setMessage(MessageFormat.format(PHPDebugUIMessages.addPHPexeDialog_wrongSAPItype, phpExecInfo.getSapiType()), 3);
            return;
        }
        if (phpExeItem.getINILocation() != null) {
            String iniLocationName = phpExeItem.getINILocation().getPath();
            File iniFile = null;
            if (iniLocationName.trim().length() > 0 && !(iniFile = new File(iniLocationName)).exists()) {
                this.setMessage(PHPDebugUIMessages.addPHPexeDialog_iniLocationNotExists, 3);
                return;
            }
        }
        this.controlHandler.update();
    }

    public boolean performOk() {
        return true;
    }

    public PHPexeItem getPHPExeItem() {
        return (PHPexeItem)super.getData();
    }

    private PHPExeUtil.PHPExeInfo getPHPInfo(File executable) {
        try {
            return PHPExeUtil.getPHPInfo((File)executable, (boolean)false);
        }
        catch (PHPExeException e) {
            return null;
        }
    }

    private void updateItem() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem == null) {
            return;
        }
        if (phpExeItem != null && !phpExeItem.isEditable()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_readOnlyPHPExe, 1);
            this.setComplete(false);
            this.validate();
            return;
        }
        phpExeItem.setLoadDefaultINI(this.fLoadDefaultPHPIni.getSelection());
        phpExeItem.setExecutable(this.fPHPExePath.getText().isEmpty() ? null : new File(this.fPHPExePath.getText()));
        phpExeItem.setName(this.fPHPexeName.getText());
        phpExeItem.setINILocation(this.fPHPIni.getText().isEmpty() ? null : new File(this.fPHPIni.getText()));
        phpExeItem.setSapiType(this.fSapiTypes.getText());
        PHPExeUtil.PHPExeInfo phpExeInfo = this.getPHPInfo(phpExeItem.getExecutable());
        if (phpExeInfo != null) {
            phpExeItem.setVersion(phpExeInfo.getVersion());
        }
        this.validate();
    }
}

