/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionTypeParameters;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class CollectionTypeParametersImpl<T extends Type>
implements CollectionTypeParameters<T> {
    private final int hashCode;
    private final @NonNull T elementType;
    private final boolean isNullFree;
    private final @NonNull IntegerValue lower;
    private final @NonNull UnlimitedNaturalValue upper;

    public CollectionTypeParametersImpl(@NonNull T elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        this.elementType = elementType;
        this.isNullFree = isNullFree;
        this.lower = lower != null ? lower : ValueUtil.ZERO_VALUE;
        this.upper = upper != null ? upper : ValueUtil.UNLIMITED_VALUE;
        int hash = elementType.getTypeId().hashCode() + (isNullFree ? 9876 : 0);
        hash = 111 * hash + this.lower.hashCode();
        this.hashCode = hash = 111 * hash + this.upper.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CollectionTypeParametersImpl)) {
            return false;
        }
        CollectionTypeParametersImpl that = (CollectionTypeParametersImpl)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (this.isNullFree != that.isNullFree) {
            return false;
        }
        if (this.elementType.getTypeId() != ((Type)that.elementType).getTypeId()) {
            return false;
        }
        if (!this.lower.equals(that.lower)) {
            return false;
        }
        return this.upper.equals(that.upper);
    }

    @Override
    public @NonNull T getElementType() {
        return this.elementType;
    }

    @Override
    public @NonNull IntegerValue getLower() {
        return this.lower;
    }

    @Override
    public @NonNull UnlimitedNaturalValue getUpper() {
        return this.upper;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isNullFree() {
        return this.isNullFree;
    }

    public @NonNull Iterator iterator() {
        return new Iterator();
    }

    public int parametersSize() {
        return 1;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        s.append(this.elementType);
        s.append(',');
        s.append(this.isNullFree);
        s.append(',');
        s.append(this.lower);
        s.append(',');
        s.append(this.upper);
        s.append(')');
        return s.toString();
    }

    protected class Iterator
    implements java.util.Iterator<Object> {
        private int position = 0;

        protected Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < 3;
        }

        @Override
        public Object next() {
            switch (this.position++) {
                case 0: {
                    return CollectionTypeParametersImpl.this.elementType;
                }
                case 1: {
                    return CollectionTypeParametersImpl.this.lower;
                }
                case 2: {
                    return CollectionTypeParametersImpl.this.upper;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

