/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.AbstractObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ObjectSelectionRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ObjectSelectionWidget
extends AbstractObjectSelectionWidget
implements IObjectSelectionWidget {
    private Composite parent;
    private Listener statusListener;
    private Composite composite;
    private IProject project;
    private String componentName;
    private IObjectSelectionWidget child;
    private Point widgetSize_;

    public WidgetDataEvents addControls(Composite parentComposite, Listener statListener) {
        this.parent = parentComposite;
        this.statusListener = statListener;
        this.composite = null;
        return this;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        if (this.composite != null) {
            this.composite.dispose();
            this.child = null;
        }
        if (typeRuntimeServer != null) {
            String wst = typeRuntimeServer.getTypeId();
            int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(wst);
            String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(wst);
            WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils2.getWebServiceImplById(implId);
            if (wsimpl != null) {
                String objectSelectionWidgetId = null;
                objectSelectionWidgetId = scenario == 1 ? "org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWidget" : wsimpl.getObjectSelectionWidget();
                Object object = ObjectSelectionRegistry.getInstance().getSelectionWidget(objectSelectionWidgetId);
                if (object instanceof IObjectSelectionWidget) {
                    this.child = (IObjectSelectionWidget)object;
                }
                if (this.child != null) {
                    Shell shell = this.parent.getShell();
                    this.composite = new Composite(this.parent, 0);
                    GridLayout gl = new GridLayout();
                    gl.marginHeight = 0;
                    gl.marginWidth = 0;
                    GridData gd = new GridData(1808);
                    this.composite.setLayout((Layout)gl);
                    this.composite.setLayoutData((Object)gd);
                    this.child.addControls(this.composite, this.statusListener);
                    Point origSize = shell.getSize();
                    Point compSize = this.composite.computeSize(-1, -1);
                    int newX = origSize.x;
                    int newY = origSize.y;
                    if (compSize.x + 20 > origSize.x) {
                        newX = compSize.x + 20;
                    }
                    if (compSize.y + 205 > origSize.y) {
                        newY = compSize.y + 205;
                    }
                    this.widgetSize_ = new Point(newX, newY);
                    return;
                }
            }
        }
    }

    public IStatus getStatus() {
        return this.child != null ? this.child.getStatus() : Status.OK_STATUS;
    }

    @Override
    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.project = this.getProjectFromInitialSelection(initialSelection);
        this.componentName = this.getComponentNameFromInitialSelection(initialSelection);
        if (this.child != null) {
            this.child.setInitialSelection(initialSelection);
        }
    }

    @Override
    public IStructuredSelection getObjectSelection() {
        return this.child != null ? this.child.getObjectSelection() : null;
    }

    @Override
    public IStatus validateSelection(IStructuredSelection objectSelection) {
        return this.child != null ? this.child.validateSelection(objectSelection) : Status.OK_STATUS;
    }

    @Override
    public IProject getProject() {
        if (this.child != null) {
            IProject p = this.child.getProject();
            if (p != null) {
                return p;
            }
            return this.project;
        }
        return null;
    }

    @Override
    public String getComponentName() {
        if (this.child != null) {
            String cname = this.child.getComponentName();
            if (cname != null && cname.length() > 0) {
                return cname;
            }
            return this.componentName;
        }
        return null;
    }

    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            IResource resource;
            block4: {
                try {
                    resource = ResourceUtils.getResourceFromSelection((Object)obj);
                    if (resource != null) break block4;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
            return p;
        }
        return null;
    }

    private String getComponentNameFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            IResource resource;
            block5: {
                try {
                    resource = ResourceUtils.getResourceFromSelection((Object)obj);
                    if (resource != null) break block5;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
            if (comp != null) {
                return comp.getName();
            }
        }
        return null;
    }

    @Override
    public String getObjectSelectionDisplayableString() {
        return this.child.getObjectSelectionDisplayableString();
    }

    @Override
    public Point getWidgetSize() {
        Point childWidgetSize = this.child.getWidgetSize();
        if (childWidgetSize == null) {
            return this.widgetSize_;
        }
        return childWidgetSize;
    }
}

