/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.FlowPage;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.html.core.internal.htmlcss.StyleListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentEditPart
extends NodeEditPart
implements StyleListener,
ICSSStyleListener {
    boolean _refreshing = false;

    protected List getModelChildren() {
        ArrayList<Node> list = new ArrayList<Node>();
        Node model = (Node)this.getModel();
        if (model == null) {
            return list;
        }
        NodeList children1 = model.getChildNodes();
        int i = 0;
        int n = children1.getLength();
        while (i < n) {
            Node node = children1.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 1) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    protected IFigure createFigure() {
        FlowPage f = new FlowPage();
        return f;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        this.refresh();
    }

    public void refresh(boolean recursive) {
        if (!recursive) {
            this.refresh();
        } else {
            this.refreshVisuals();
            this.refreshChildren(recursive);
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    public void refresh() {
        if (this._refreshing) {
            return;
        }
        this._refreshing = true;
        try {
            super.refresh();
        }
        finally {
            this._refreshing = false;
        }
    }

    protected void refreshChildren() {
        this.refreshChildren(false);
    }

    protected void refreshChildren(boolean recursive) {
        super.refreshChildren();
        List children1 = this.getChildren();
        int i = 0;
        int size = children1.size();
        while (i < size) {
            EditPart editPart = (EditPart)children1.get(i);
            if (editPart instanceof ElementEditPart) {
                ((ElementEditPart)editPart).refresh(recursive);
            } else {
                editPart.refresh();
            }
            ++i;
        }
    }

    public void styleChanged() {
        this.refreshStyle();
    }

    public void styleChanged(ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
        if (removed != null && removed.length > 0 || added != null && added.length > 0) {
            this.refreshStyle();
        }
    }

    public void styleUpdate(ICSSModel srcModel) {
        this.refreshStyle();
    }

    private void refreshStyle() {
        List childParts = this.getChildren();
        for (EditPart part : childParts) {
            IDOMNode node;
            if (!(part instanceof ElementEditPart) || (node = (IDOMNode)((ElementEditPart)part).getNodeForFigure()) == null) continue;
            this.refreshChildStyles(node);
        }
        this.getFigure().revalidate();
    }

    private void refreshChildStyles(IDOMNode node) {
        ICSSStyle a;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        int size = childNodes.getLength();
        while (i < size) {
            this.refreshChildStyles((IDOMNode)childNodes.item(i));
            ++i;
        }
        if (node instanceof IDOMElement && (a = (ICSSStyle)node.getAdapterFor(ICSSStyle.class)) != null) {
            a.reset();
        }
    }
}

