/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.editpolicies.FragmentCornerHandle;

public class FragmentHandle
extends AbstractHandle
implements Handle {
    public FragmentHandle(GraphicalEditPart owner) {
        super(owner, (Locator)new FragmentLocator());
        this.setOpaque(false);
    }

    public void paint(Graphics graphics) {
        graphics.setClip(this.getBounds().getCopy().expand(7, 7));
        super.paint(graphics);
    }

    protected DragTracker createDragTracker() {
        DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    private void refresh() {
        this.bounds = this.getOwnerFigure().getBounds();
        this.bounds = new PrecisionRectangle(this.bounds.getResized(-1, -1));
        this.getOwnerFigure().translateToAbsolute((Translatable)this.bounds);
        this.translateToRelative((Translatable)this.bounds);
        this.setBounds(this.bounds);
        this.removeAll();
        CSSFigure cssfigure = (CSSFigure)this.getOwner().getFigure();
        List fragments = cssfigure.getFragmentsForRead();
        int i = 0;
        int size = fragments.size();
        while (i < size) {
            BorderFigure childFigure = new BorderFigure();
            childFigure.setBorder((Border)new LineBorder(1));
            this.add((IFigure)childFigure);
            FlowBox box = (FlowBox)fragments.get(i);
            Rectangle rect = new Rectangle(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            cssfigure.translateToAbsolute((Translatable)rect);
            childFigure.translateToRelative((Translatable)rect);
            childFigure.setBounds(rect);
            this.createCornerHandles(cssfigure, box);
            ++i;
        }
    }

    private void createCornerHandles(CSSFigure reference, FlowBox referencebox) {
        this.createHandle(reference, referencebox, 20);
        this.createHandle(reference, referencebox, 12);
        this.createHandle(reference, referencebox, 9);
        this.createHandle(reference, referencebox, 17);
    }

    public boolean containsPoint(int x, int y) {
        List children = this.getChildren();
        int i = 0;
        int n = children.size();
        while (i < n) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void createHandle(CSSFigure reference, FlowBox referencebox, int location) {
        double relativeY = switch (location & 5) {
            case 1 -> 0.0;
            case 4 -> 1.0;
            default -> 0.5;
        };
        double relativeX = switch (location & 0x18) {
            case 8 -> 0.0;
            case 16 -> 1.0;
            default -> 0.5;
        };
        FragmentCornerHandle target = new FragmentCornerHandle(this.getOwner());
        this.add((IFigure)target);
        Rectangle targetBounds = new Rectangle(referencebox.getX(), referencebox.getY(), referencebox.getWidth(), referencebox.getHeight());
        targetBounds = new PrecisionRectangle(targetBounds);
        reference.translateToAbsolute((Translatable)targetBounds);
        target.translateToRelative((Translatable)targetBounds);
        Dimension targetSize = target.getPreferredSize();
        targetBounds.x += (int)((double)targetBounds.width * relativeX - (double)((targetSize.width + 1) / 2));
        targetBounds.y += (int)((double)targetBounds.height * relativeY - (double)((targetSize.height + 1) / 2));
        targetBounds.setSize(targetSize);
        target.setBounds(targetBounds);
    }

    static class BorderFigure
    extends Figure {
        public static final int INNER_PAD = 2;

        BorderFigure() {
        }

        public boolean containsPoint(int x, int y) {
            if (!super.containsPoint(x, y)) {
                return false;
            }
            return !Rectangle.SINGLETON.setBounds(this.getBounds()).shrink(2, 2).contains(x, y);
        }
    }

    static class FragmentLocator
    implements Locator {
        FragmentLocator() {
        }

        public void relocate(IFigure target) {
            ((FragmentHandle)target).refresh();
        }
    }
}

