/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaContextRoot;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlDefinition;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model.EclipseLinkDynamicEntityField;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.operation.EclipseLinkNewDynamicEntityClassOperation;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.plugin.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.IEntityDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class EclipseLinkDynamicEntityDataModelProvider
extends NewJavaClassDataModelProvider
implements IEntityDataModelProperties {
    private static final String DOT = ".";

    public IDataModelOperation getDefaultOperation() {
        return new EclipseLinkNewDynamicEntityClassOperation(this.getDataModel());
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEntityDataModelProperties.ENTITY");
        propertyNames.add("IEntityDataModelProperties.XML_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_NAME");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_FIELDS");
        propertyNames.add("IEntityDataModelProperties.PK_FIELDS");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IEntityDataModelProperties.ENTITY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME_DEFAULT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT")) {
            return this.getJavaPackageFragmentRoots();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (ok && ("IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName) || "IEntityDataModelProperties.XML_SUPPORT".equals(propertyName))) {
            this.model.notifyPropertyChange("IEntityDataModelProperties.XML_NAME", 4);
        }
        return ok;
    }

    protected IPackageFragmentRoot[] getJavaPackageFragmentRoots() {
        IJavaProject javaProject;
        EclipseLinkJpaProject jpaProject = this.getJpaProject();
        IPackageFragmentRoot[] packRoots = new IPackageFragmentRoot[]{};
        ArrayList<IPackageFragmentRoot> rootList = new ArrayList<IPackageFragmentRoot>();
        if (jpaProject != null && (javaProject = jpaProject.getJavaProject()) != null) {
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = packRoots = javaProject.getAllPackageFragmentRoots();
                int n = packRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1) {
                        rootList.add(root);
                    }
                    ++n2;
                }
                packRoots = new IPackageFragmentRoot[rootList.size()];
                rootList.toArray(packRoots);
            }
            catch (JavaModelException e) {
                JptJpaEclipseLinkUiPlugin.instance().logError(e);
            }
        }
        return packRoots;
    }

    public IStatus validate(String propertyName) {
        IStatus result = super.validate(propertyName);
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return this.validateXmlName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return this.validateFieldsList((ArrayList)this.getProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return this.validatePrimaryKeyFieldsList((ArrayList)this.getProperty(propertyName));
        }
        return result;
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName == null || packName.equals("")) {
            return JptJpaEclipseLinkUiPlugin.instance().buildStatus(2, JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_DEFAULT_PACKAGE_WARNING);
        }
        IStatus javaStatus = JavaConventions.validatePackageName((String)packName, (String)"1.5", (String)"1.5");
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateXmlName(String xmlName) {
        IProject project = this.getTargetProject();
        if (project != null) {
            JptXmlResource ormXmlResource;
            JptXmlResource jptXmlResource = ormXmlResource = StringTools.isBlank((String)xmlName) ? null : this.getOrmXmlResource(xmlName);
            if (ormXmlResource == null) {
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_INVALID_XML_NAME);
            }
            if (this.getJpaProject().getJpaFile(ormXmlResource.getFile()).getRootStructureNodesSize() == 0) {
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_XML_NOT_LISTED_ERROR);
            }
        }
        return Status.OK_STATUS;
    }

    protected JptXmlResource getOrmXmlResource(String xmlName) {
        return this.getJpaProject() == null ? null : this.getJpaProject().getMappingFileXmlResource((IPath)new Path(xmlName));
    }

    private IStatus validateFieldsList(ArrayList<EclipseLinkDynamicEntityField> fields) {
        if (fields != null && !fields.isEmpty()) {
            boolean hasDuplicates = this.hasDuplicatesInEntityFields(fields);
            if (hasDuplicates) {
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_DUPLICATE_ENTITY_FIELDS_ERROR);
            }
            String errorMsg1 = this.checkInputFieldsMappingTypes(fields);
            if (errorMsg1 != null) {
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(errorMsg1);
            }
            String errorMsg2 = this.checkInputFieldsAttributeTypeValidity(fields);
            if (errorMsg2 != null) {
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(errorMsg2);
            }
            String errorMsg3 = this.checkInputFieldsAttributeTypeExistence(fields);
            if (errorMsg3 != null) {
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(errorMsg3);
            }
            String warningMsg1 = this.checkInputFieldsAttributeTypeExistence(fields);
            if (warningMsg1 != null) {
                return JptJpaEclipseLinkUiPlugin.instance().buildWarningStatus(warningMsg1);
            }
            String warningMsg2 = this.checkInputFieldsTargetTypeExistence(fields);
            if (warningMsg2 != null) {
                return JptJpaEclipseLinkUiPlugin.instance().buildWarningStatus(warningMsg2);
            }
        }
        return Status.OK_STATUS;
    }

    private String checkInputFieldsMappingTypes(ArrayList<EclipseLinkDynamicEntityField> fields) {
        IStatus validateFieldMappingTypeStatus = Status.OK_STATUS;
        Iterable<String> mappingKeys = this.getMappingKeys(fields);
        if (this.hasIDAndEmbeddedIDMappingDefined(mappingKeys)) {
            validateFieldMappingTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_BOTH_ID_AND_EMBEDDED_ID_DEFINED_ERROR);
        } else if (this.hasMultipleEmbeddedIDMappings(mappingKeys)) {
            validateFieldMappingTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_MULTIPLE_EMBEDDED_IDS_DEFINED_ERROR);
        }
        if (!validateFieldMappingTypeStatus.isOK()) {
            return validateFieldMappingTypeStatus.getMessage();
        }
        return null;
    }

    private Iterable<String> getMappingKeys(ArrayList<EclipseLinkDynamicEntityField> fields) {
        return IterableTools.transform(fields, (Transformer)new MappingKeyFieldTransformer());
    }

    private boolean hasIDAndEmbeddedIDMappingDefined(Iterable<String> mappingKeys) {
        return IterableTools.contains(mappingKeys, (Object)"id") && IterableTools.contains(mappingKeys, (Object)"embeddedId");
    }

    private boolean hasMultipleEmbeddedIDMappings(Iterable<String> mappingKeys) {
        int i = 0;
        for (String key : mappingKeys) {
            if (key != "embeddedId" || ++i <= 1) continue;
            return true;
        }
        return false;
    }

    private String checkInputFieldsAttributeTypeValidity(List<EclipseLinkDynamicEntityField> fields) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EclipseLinkDynamicEntityField field : fields) {
            String elementSignature;
            if (this.getAttributeMappingDefinition(field.getMappingType().getKey()).isSingleRelationshipMapping()) continue;
            if (field.isKey() && !field.couldTypeBePKType()) {
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_INVALID_PK_TYPE, new Object[]{field.getFqnAttributeType()});
                break;
            }
            String sig = null;
            try {
                sig = Signature.createTypeSignature((String)field.getFqnAttributeType(), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_INVALID_ARGUMENT, new Object[]{e.getLocalizedMessage()});
                break;
            }
            if (sig == null) {
                validateFieldTypeStatus = JavaConventions.validateJavaTypeName((String)field.getAttributeType(), (String)"1.5", (String)"1.5");
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType != 2 && sigType == 4 && Signature.getTypeSignatureKind((String)(elementSignature = Signature.getElementType((String)sig))) != 2) continue;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    protected String checkInputFieldsAttributeTypeExistence(List<EclipseLinkDynamicEntityField> fields) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EclipseLinkDynamicEntityField field : fields) {
            if (this.getAttributeMappingDefinition(field.getMappingType().getKey()).isSingleRelationshipMapping()) continue;
            String sig = Signature.createTypeSignature((String)field.getFqnAttributeType(), (boolean)true);
            if (sig == null) {
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{field.getFqnAttributeType()});
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType == 2) continue;
            if (sigType == 4) {
                String elementSignature = Signature.getElementType((String)sig);
                if (Signature.getTypeSignatureKind((String)elementSignature) == 2) continue;
                String qualifiedName = Signature.toString((String)elementSignature);
                IProject project = this.getTargetProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType type = null;
                try {
                    type = javaProject.findType(qualifiedName);
                }
                catch (JavaModelException e) {
                    validateFieldTypeStatus = e.getStatus();
                    break;
                }
                if (type != null) continue;
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{field.getFqnAttributeType()});
                break;
            }
            IProject project = this.getTargetProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            try {
                type = javaProject.findType(field.getFqnAttributeType());
            }
            catch (JavaModelException e) {
                validateFieldTypeStatus = e.getStatus();
                break;
            }
            if (type != null) continue;
            validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{field.getFqnAttributeType()});
            break;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private String checkInputFieldsTargetTypeValidity(List<EclipseLinkDynamicEntityField> fields) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EclipseLinkDynamicEntityField field : fields) {
            String elementSignature;
            if (!this.getAttributeMappingDefinition(field.getMappingType().getKey()).isSingleRelationshipMapping() && !this.getAttributeMappingDefinition(field.getMappingType().getKey()).isCollectionMapping()) continue;
            String sig = null;
            try {
                sig = Signature.createTypeSignature((String)field.getFqnTargetType(), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_INVALID_ARGUMENT, new Object[]{e.getLocalizedMessage()});
                break;
            }
            if (sig == null) {
                validateFieldTypeStatus = JavaConventions.validateJavaTypeName((String)field.getTargetType(), (String)"1.5", (String)"1.5");
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType != 2 && sigType == 4 && Signature.getTypeSignatureKind((String)(elementSignature = Signature.getElementType((String)sig))) != 2) continue;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    protected String checkInputFieldsTargetTypeExistence(List<EclipseLinkDynamicEntityField> fields) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EclipseLinkDynamicEntityField field : fields) {
            if (!this.getAttributeMappingDefinition(field.getMappingType().getKey()).isSingleRelationshipMapping() && !this.getAttributeMappingDefinition(field.getMappingType().getKey()).isCollectionMapping()) continue;
            String sig = Signature.createTypeSignature((String)field.getFqnTargetType(), (boolean)true);
            if (sig == null) {
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{field.getFqnTargetType()});
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType == 2) continue;
            if (sigType == 4) {
                String elementSignature = Signature.getElementType((String)sig);
                if (Signature.getTypeSignatureKind((String)elementSignature) == 2) continue;
                String qualifiedName = Signature.toString((String)elementSignature);
                IProject project = this.getTargetProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType type = null;
                try {
                    type = javaProject.findType(qualifiedName);
                }
                catch (JavaModelException e) {
                    validateFieldTypeStatus = e.getStatus();
                    break;
                }
                if (type != null) continue;
                validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{field.getFqnTargetType()});
                break;
            }
            IProject project = this.getTargetProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            try {
                type = javaProject.findType(field.getFqnTargetType());
            }
            catch (JavaModelException e) {
                validateFieldTypeStatus = e.getStatus();
                break;
            }
            if (type != null) continue;
            validateFieldTypeStatus = JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH, new Object[]{field.getFqnTargetType()});
            break;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private boolean hasDuplicatesInEntityFields(ArrayList<EclipseLinkDynamicEntityField> fields) {
        if (fields == null) {
            return false;
        }
        int n = fields.size();
        int i = 0;
        while (i < n) {
            EclipseLinkDynamicEntityField field = fields.get(i);
            int j = i + 1;
            while (j < n) {
                EclipseLinkDynamicEntityField intEntity = fields.get(j);
                if (intEntity.getName().equals(field.getName())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private IStatus validatePrimaryKeyFieldsList(ArrayList<EclipseLinkDynamicEntityField> pkFields) {
        return pkFields.size() > 1 ? JptJpaEclipseLinkUiPlugin.instance().buildStatus(1, JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_APPLY_EMBEDDED_ID_MAPPING_INFO) : null;
    }

    protected IStatus canCreateTypeInClasspath(String packageName, String typeName) {
        String fullyQualifiedName = "";
        fullyQualifiedName = !StringTools.isBlank((String)packageName) ? String.valueOf(packageName) + DOT + typeName : typeName;
        for (String name : this.getJavaTypeNames()) {
            if (ObjectTools.equals((Object)name, (Object)fullyQualifiedName)) {
                return JptJpaEclipseLinkUiPlugin.instance().buildStatus(2, JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_EXISTS_WARNING, new Object[]{fullyQualifiedName});
            }
            if (!StringTools.equalsIgnoreCase((String)name, (String)fullyQualifiedName)) continue;
            return JptJpaEclipseLinkUiPlugin.instance().buildStatus(2, JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_WITH_DIFF_CASE_EXISTS_WARNING, new Object[]{fullyQualifiedName});
        }
        PersistenceUnit pu = this.getPersistenceUnit();
        if (pu != null) {
            for (String name : ((EclipseLinkPersistenceUnit)pu).getEclipseLinkDynamicPersistentTypeNames()) {
                if (ObjectTools.equals((Object)name, (Object)fullyQualifiedName)) {
                    return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_DYNAMIC_TYPE_EXISTS_ERROR, new Object[]{fullyQualifiedName});
                }
                if (!StringTools.equalsIgnoreCase((String)name, (String)fullyQualifiedName)) continue;
                return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_DYNAMIC_TYPE_WITH_DIFF_CASE_EXISTS_ERROR, new Object[]{fullyQualifiedName});
            }
        } else {
            return JptJpaEclipseLinkUiPlugin.instance().buildErrorStatus(JptJpaEclipseLinkUiMessages.ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_ECLIPSELINK_PROJECT_NOT_FOUND_ERROR);
        }
        return Status.OK_STATUS;
    }

    private Iterable<String> getJavaTypeNames() {
        return IterableTools.transform(this.getJavaTypes(), (Transformer)TypeTools.NAME_TRANSFORMER);
    }

    protected List<IType> getJavaTypes() {
        IPackageFragmentRoot[] packRoots = this.getJavaPackageFragmentRoots();
        ArrayList<IType> typesList = new ArrayList<IType>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = packRoots;
        int n = packRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                IJavaElement[] jElements;
                IJavaElement[] iJavaElementArray = jElements = root.getChildren();
                int n3 = jElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement jElement = iJavaElementArray[n4];
                    if (jElement.getElementType() == 4) {
                        ICompilationUnit[] units;
                        ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)jElement).getCompilationUnits();
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit unit = iCompilationUnitArray[n6];
                            CollectionTools.addAll(typesList, (Object[])unit.getTypes());
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            catch (JavaModelException e) {
                JptJpaEclipseLinkUiPlugin.instance().logError(e);
            }
            ++n2;
        }
        return typesList;
    }

    protected EclipseLinkJpaProject getJpaProject() {
        IProject project = this.getTargetProject();
        return project != null && this.isEclipseLinkProject(project) ? this.getJpaProject(project) : null;
    }

    protected boolean isEclipseLinkProject(IProject project) {
        return this.getJpaPlatformConfig(project) == null ? false : ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET) && this.getJpaPlatformConfig(project).getGroupConfig().getId().equals("eclipselink");
    }

    protected EclipseLinkJpaProject getJpaProject(IProject project) {
        return (EclipseLinkJpaProject)project.getAdapter(JpaProject.class);
    }

    protected JpaPlatform.Config getJpaPlatformConfig(IProject project) {
        return (JpaPlatform.Config)project.getAdapter(JpaPlatform.Config.class);
    }

    protected PersistenceUnit getPersistenceUnit() {
        Persistence p = this.getPersistence();
        if (p == null) {
            return null;
        }
        ListIterator units = p.getPersistenceUnits().iterator();
        return units.hasNext() ? (PersistenceUnit)units.next() : null;
    }

    protected Persistence getPersistence() {
        PersistenceXml pxml = this.getPersistenceXml();
        return pxml == null ? null : pxml.getRoot();
    }

    protected PersistenceXml getPersistenceXml() {
        EclipseLinkJpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        JpaContextRoot root = jpaProject.getContextRoot();
        return root == null ? null : root.getPersistenceXml();
    }

    protected OrmAttributeMappingDefinition getAttributeMappingDefinition(String mappingKey) {
        return this.getOrmXmlDefinition().getAttributeMappingDefinition(mappingKey);
    }

    private OrmXmlDefinition getOrmXmlDefinition() {
        return (OrmXmlDefinition)this.getJpaProject().getJpaPlatform().getResourceDefinition(this.getJptResourceType());
    }

    private JptResourceType getJptResourceType() {
        return this.getOrmXmlResource(this.getStringProperty("IEntityDataModelProperties.XML_NAME")).getResourceType();
    }

    static class MappingKeyFieldTransformer
    extends TransformerAdapter<EclipseLinkDynamicEntityField, String> {
        MappingKeyFieldTransformer() {
        }

        public String transform(EclipseLinkDynamicEntityField field) {
            return field.getMappingType().getKey();
        }
    }
}

