/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.validation.JptJpaEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class EclipseLinkConvertValidator
implements JpaValidator {
    protected final EclipseLinkConvert convert;

    public EclipseLinkConvertValidator(EclipseLinkConvert convert) {
        this.convert = convert;
    }

    protected AttributeMapping getAttributeMapping() {
        return this.convert.getParent();
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return this.convert.getPersistenceUnit();
    }

    public boolean validate(List<IMessage> messages, IReporter reporter) {
        return this.validateConverterName(messages);
    }

    private boolean validateConverterName(List<IMessage> messages) {
        String converterName = this.convert.getConverterName();
        if (converterName == null) {
            return true;
        }
        if (IterableTools.contains(this.getPersistenceUnit().getUniqueConverterNames(), (Object)converterName)) {
            return true;
        }
        if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)converterName)) {
            return true;
        }
        messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.getAttributeMapping().getResource(), (TextRange)this.getValidationTextRange(), (ValidationMessage)JptJpaEclipseLinkCoreValidationMessages.ID_MAPPING_UNRESOLVED_CONVERTER_NAME, (Object[])new Object[]{converterName, this.getAttributeMapping().getName()}));
        return false;
    }

    protected TextRange getValidationTextRange() {
        return this.getAttributeMapping().getPersistentAttribute().isVirtual() ? this.getVirtualValidationTextRange() : this.convert.getValidationTextRange();
    }

    protected TextRange getVirtualValidationTextRange() {
        return this.getAttributeMapping().getPersistentAttribute().getValidationTextRange();
    }
}

