/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.plugin.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ClassesGeneratorExtensionOptionsWizardPage
extends WizardPage {
    public static final String TARGET_OPTION = "-target ";
    private ExtensionOptionsComposite additionalArgsComposite;

    protected ClassesGeneratorExtensionOptionsWizardPage() {
        super("Classes Generator Extension Options");
        this.initialize();
    }

    protected void initialize() {
        this.setTitle(JptJaxbUiMessages.CLASSES_GENERATOR_EXTENSION_OPTIONS_WIZARD_PAGE_TITLE);
        this.setDescription(JptJaxbUiMessages.CLASSES_GENERATOR_EXTENSION_OPTIONS_WIZARD_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(true);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.additionalArgsComposite = new ExtensionOptionsComposite(composite);
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String facetVersion = this.getFacetVersion();
        if (StringTools.isNotBlank((String)facetVersion) && StringTools.isBlank((String)this.additionalArgsComposite.getAdditionalArgs())) {
            this.additionalArgsComposite.setAdditionalArgs(TARGET_OPTION + facetVersion);
        }
    }

    protected boolean allowsExtensions() {
        return this.additionalArgsComposite.allowsExtensions();
    }

    protected String getClasspath() {
        return this.additionalArgsComposite.getClasspath();
    }

    protected String getAdditionalArgs() {
        return this.additionalArgsComposite.getAdditionalArgs();
    }

    private String getFacetVersion() {
        IProjectFacetVersion projectFacetVersion = this.getProjectFacetVersion();
        return projectFacetVersion == null ? null : projectFacetVersion.getVersionString();
    }

    private IProjectFacetVersion getProjectFacetVersion() {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)this.getProject());
        }
        catch (CoreException e) {
            JptJaxbUiPlugin.instance().logError(e);
            return null;
        }
        return facetedProject == null ? null : facetedProject.getProjectFacetVersion(JaxbProject.FACET);
    }

    private IProject getProject() {
        return ((ClassesGeneratorWizard)this.getWizard()).getJavaProject().getProject();
    }

    class ExtensionOptionsComposite {
        private boolean allowsExtensions = false;
        private final Text classpathText;
        private final Button allowsExtensionsCheckBox;
        private final Text additionalArgsText;

        private ExtensionOptionsComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.allowsExtensionsCheckBox = this.buildAllowsExtensionsCheckBox(composite, this.buildAllowsExtensionsSelectionListener());
            Label classpathLabel = new Label(composite, 0);
            classpathLabel.setText(JptJaxbUiMessages.CLASSES_GENERATOR_EXTENSION_OPTIONS_WIZARD_PAGE_CLASSPATH);
            GridData gridData = new GridData();
            gridData.verticalIndent = 5;
            classpathLabel.setLayoutData((Object)gridData);
            this.classpathText = this.buildClasspathText(composite);
            Label additionalArgsLabel = new Label(composite, 0);
            additionalArgsLabel.setText(JptJaxbUiMessages.CLASSES_GENERATOR_EXTENSION_OPTIONS_WIZARD_PAGE_ADDITIONAL_ARGUMENTS);
            gridData = new GridData();
            gridData.verticalIndent = 5;
            additionalArgsLabel.setLayoutData((Object)gridData);
            this.additionalArgsText = this.buildAdditionalArgsText(composite);
        }

        private Button buildAllowsExtensionsCheckBox(Composite parent, SelectionListener listener) {
            Button checkBox = new Button(parent, 32);
            GridData gridData = new GridData();
            gridData.verticalIndent = 5;
            checkBox.setLayoutData((Object)gridData);
            checkBox.setText(JptJaxbUiMessages.CLASSES_GENERATOR_EXTENSION_OPTIONS_WIZARD_PAGE_ALLOW_EXTENSIONS);
            checkBox.setSelection(this.allowsExtensions());
            checkBox.addSelectionListener(listener);
            return checkBox;
        }

        private Text buildClasspathText(Composite parent) {
            Text text = new Text(parent, 2562);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.verticalIndent = 1;
            gridData.heightHint = text.getLineHeight() * 3;
            gridData.grabExcessHorizontalSpace = true;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private Text buildAdditionalArgsText(Composite parent) {
            Text text = new Text(parent, 2562);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            gridData.verticalIndent = 1;
            gridData.heightHint = text.getLineHeight() * 10;
            gridData.grabExcessHorizontalSpace = true;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private SelectionListener buildAllowsExtensionsSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    ExtensionOptionsComposite.this.setAllowsExtensions(ExtensionOptionsComposite.this.allowsExtensionsCheckBox.getSelection());
                }
            };
        }

        protected boolean allowsExtensions() {
            return this.allowsExtensions;
        }

        protected void setAllowsExtensions(boolean allowsExtensions) {
            this.allowsExtensions = allowsExtensions;
        }

        protected String getClasspath() {
            return this.classpathText.getText();
        }

        protected String getAdditionalArgs() {
            return this.additionalArgsText.getText();
        }

        protected void setAdditionalArgs(String argsString) {
            this.additionalArgsText.setText(argsString);
        }
    }
}

