/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;
import org.eclipse.jpt.common.utility.internal.SimpleMethodSignature;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class ASTTools {
    private static final Transformer<ITypeBinding, String> TYPE_BINDING_QUALIFIED_NAME_TRANSFORMER = new TypeBindingQualifiedNameTransformer();
    private static final Transformer<ITypeBinding, String> NULL_CHECK_TYPE_BINDING_QUALIFIED_NAME_TRANSFORMER = TransformerTools.nullCheck(TYPE_BINDING_QUALIFIED_NAME_TRANSFORMER);
    private static final Transformer<Expression, ITypeBinding> EXPRESSION_TYPE_BINDING_TRANSFORMER = new ExpressionTypeBindingTransformer();

    public static CompilationUnit buildASTRoot(ICompilationUnit compilationUnit) {
        ASTParser parser = ASTTools.newParser();
        parser.setSource(compilationUnit);
        return (CompilationUnit)parser.createAST(null);
    }

    public static IBinding createBinding(IMember member) {
        ASTParser parser = ASTTools.newParser();
        parser.setProject(member.getJavaProject());
        return parser.createBindings(new IJavaElement[]{member}, null)[0];
    }

    public static ASTParser newParser() {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setIgnoreMethodBodies(true);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        return parser;
    }

    public static String resolveEnum(Expression expression) {
        if (expression == null) {
            return null;
        }
        switch (expression.getNodeType()) {
            case 40: 
            case 42: {
                return ASTTools.resolveEnum((Name)expression);
            }
        }
        return null;
    }

    public static String resolveEnum(Name enumExpression) {
        IBinding binding = enumExpression.resolveBinding();
        if (binding == null) {
            return null;
        }
        if (binding.getKind() != 3) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        return variableBinding.getType().getQualifiedName() + "." + variableBinding.getName();
    }

    public static String resolveFullyQualifiedName(Expression expression) {
        ITypeBinding resolvedTypeBinding = ASTTools.resolveTypeBinding(expression);
        return resolvedTypeBinding == null ? null : resolvedTypeBinding.getQualifiedName();
    }

    public static Iterable<String> resolveFullyQualifiedNames(Expression expression) {
        return IterableTools.transform(ASTTools.resolveTypeBindings(expression), NULL_CHECK_TYPE_BINDING_QUALIFIED_NAME_TRANSFORMER);
    }

    public static ITypeBinding resolveTypeBinding(Expression expression) {
        if (expression != null && expression.getNodeType() == 57) {
            return ((TypeLiteral)expression).getType().resolveBinding();
        }
        return null;
    }

    public static Iterable<ITypeBinding> resolveTypeBindings(Expression expression) {
        return expression != null && expression.getNodeType() == 4 ? ASTTools.resolveTypeBindings((ArrayInitializer)expression) : EmptyIterable.instance();
    }

    private static Iterable<ITypeBinding> resolveTypeBindings(ArrayInitializer arrayExpression) {
        List expressions = arrayExpression.expressions();
        return IterableTools.transform((Iterable)expressions, EXPRESSION_TYPE_BINDING_TRANSFORMER);
    }

    public static MethodSignature buildMethodSignature(MethodDeclaration methodDeclaration) {
        return new SimpleMethodSignature(methodDeclaration.getName().getFullyQualifiedName(), ASTTools.buildParameterTypes(methodDeclaration));
    }

    public static JavaType[] buildParameterTypes(MethodDeclaration methodDeclaration) {
        List<SingleVariableDeclaration> parameters = ASTTools.parameters(methodDeclaration);
        int len = parameters.size();
        JavaType[] parameterTypes = new JavaType[len];
        int i = 0;
        while (i < len) {
            ITypeBinding type = parameters.get(i).getType().resolveBinding();
            parameterTypes[i] = SimpleJavaType.buildSimpleJavaType((String)type.getQualifiedName(), (int)type.getDimensions());
            ++i;
        }
        return parameterTypes;
    }

    private static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    public static boolean typeIsSubTypeOf(ITypeBinding typeBinding, String searchTypeName) {
        return ASTTools.findTypeInHierarchy(typeBinding, searchTypeName) != null;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding typeBinding, String searchTypeName) {
        return ASTTools.findTypeInHierarchy(typeBinding, searchTypeName, new HashSet<String>());
    }

    private static ITypeBinding findTypeInHierarchy(ITypeBinding typeBinding, String searchTypeName, HashSet<String> visited) {
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        if (visited.contains(typeName)) {
            return null;
        }
        if (typeName.equals(searchTypeName)) {
            return typeBinding;
        }
        visited.add(typeName);
        ITypeBinding interfaceBinding = ASTTools.findTypeInInterfaces(typeBinding, searchTypeName, visited);
        if (interfaceBinding != null) {
            return interfaceBinding;
        }
        return ASTTools.findTypeInSuperclasses(typeBinding, searchTypeName, visited);
    }

    private static ITypeBinding findTypeInInterfaces(ITypeBinding typeBinding, String searchTypeName, HashSet<String> visited) {
        ITypeBinding[] interfaceBindings;
        ITypeBinding[] iTypeBindingArray = interfaceBindings = typeBinding.getInterfaces();
        int n = interfaceBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            ITypeBinding result = ASTTools.findTypeInHierarchy(interfaceBinding, searchTypeName, visited);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private static ITypeBinding findTypeInSuperclasses(ITypeBinding typeBinding, String searchTypeName, HashSet<String> visited) {
        ITypeBinding result;
        ITypeBinding superBinding = typeBinding.getSuperclass();
        if (superBinding != null && (result = ASTTools.findTypeInHierarchy(superBinding, searchTypeName, visited)) != null) {
            return result;
        }
        return null;
    }

    public static boolean typeImplementsInterface(ITypeBinding typeBinding, String searchInterfaceName) {
        return ASTTools.findInterfaceInHierarchy(typeBinding, searchInterfaceName) != null;
    }

    private static ITypeBinding findInterfaceInHierarchy(ITypeBinding typeBinding, String searchInterfaceName) {
        HashSet<String> visited = new HashSet<String>();
        ITypeBinding interfaceBinding = ASTTools.findTypeInInterfaces(typeBinding, searchInterfaceName, visited);
        if (interfaceBinding != null) {
            return interfaceBinding;
        }
        return ASTTools.findTypeInSuperclasses(typeBinding, searchInterfaceName, visited);
    }

    public static TextRange buildTextRange(ASTNode astNode) {
        return ASTTools.buildTextRange(astNode, null);
    }

    public static List<TextRange> buildTextRanges(ASTNode astNode) {
        return ASTTools.buildTextRanges(astNode, null);
    }

    public static TextRange buildTextRange(ASTNode astNode, TextRange textRange) {
        int offset = astNode.getStartPosition();
        int length = astNode.getLength();
        int lineNumber = ((CompilationUnit)astNode.getRoot()).getLineNumber(offset);
        return textRange == null ? new SimpleTextRange(offset, length, lineNumber) : textRange.buildTextRange(offset, length, lineNumber);
    }

    public static List<TextRange> buildTextRanges(ASTNode astNode, TextRange textRange) {
        if (astNode.getNodeType() == 27) {
            return ASTTools.buildTextRanges((InfixExpression)astNode, textRange);
        }
        return Collections.singletonList(ASTTools.buildTextRange(astNode, textRange));
    }

    public static List<TextRange> buildTextRanges(InfixExpression expression, TextRange textRange) {
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>();
        TextRange leftTextRange = ASTTools.buildTextRange((ASTNode)expression.getLeftOperand(), textRange);
        textRanges.add(leftTextRange);
        TextRange rightTextRange = ASTTools.buildTextRange((ASTNode)expression.getRightOperand(), textRange);
        textRanges.add(rightTextRange);
        for (Expression child : expression.extendedOperands()) {
            TextRange childTextRange = ASTTools.buildTextRange((ASTNode)child, textRange);
            textRanges.add(childTextRange);
        }
        return textRanges;
    }

    static class ExpressionTypeBindingTransformer
    extends TransformerAdapter<Expression, ITypeBinding> {
        ExpressionTypeBindingTransformer() {
        }

        public ITypeBinding transform(Expression expression) {
            return ASTTools.resolveTypeBinding(expression);
        }
    }

    static class TypeBindingQualifiedNameTransformer
    extends TransformerAdapter<ITypeBinding, String> {
        TypeBindingQualifiedNameTransformer() {
        }

        public String transform(ITypeBinding typeBinding) {
            return typeBinding.getQualifiedName();
        }
    }
}

