/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;

public class ReplaceDeprecatedFieldFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ReplaceDeprecatedFieldFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public ReplaceDeprecatedFieldFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
    }

    public static ReplaceDeprecatedFieldFixCore create(String name, String replacement, CompilationUnit compilationUnit, ASTNode node) {
        return new ReplaceDeprecatedFieldFixCore(name, compilationUnit, new ReplaceDeprecatedFieldProposalOperation(node, replacement));
    }

    public static class ReplaceDeprecatedFieldProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ASTNode fNode;
        private final String fReplacement;

        public ReplaceDeprecatedFieldProposalOperation(ASTNode node, String name) {
            this.fNode = node;
            this.fReplacement = name;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ImportRemover importRemover = cuRewrite.getImportRemover();
            IPackageDeclaration[] packageDecls = cuRewrite.getCu().getPackageDeclarations();
            IVariableBinding fieldBinding = null;
            switch (this.fNode.getNodeType()) {
                case 40: {
                    fieldBinding = (IVariableBinding)((QualifiedName)this.fNode).resolveBinding();
                    break;
                }
                case 42: {
                    fieldBinding = (IVariableBinding)((SimpleName)this.fNode).resolveBinding();
                    break;
                }
                case 22: {
                    fieldBinding = ((FieldAccess)this.fNode).resolveFieldBinding();
                    break;
                }
                case 47: {
                    fieldBinding = ((SuperFieldAccess)this.fNode).resolveFieldBinding();
                    break;
                }
            }
            boolean sameClass = false;
            boolean mustQualify = false;
            int simpleNameQualifierIndex = -1;
            String simpleNameQualifier = "";
            int lastDot = this.fReplacement.lastIndexOf(46);
            if (lastDot > 0) {
                IImportDeclaration[] importDecls;
                ITypeBinding classBinding;
                String className;
                int startIndex = lastDot - 1;
                while (startIndex >= 0 && Character.isJavaIdentifierPart(this.fReplacement.charAt(startIndex))) {
                    --startIndex;
                }
                simpleNameQualifierIndex = startIndex + 1;
                simpleNameQualifier = this.fReplacement.substring(simpleNameQualifierIndex, lastDot);
                if (fieldBinding != null && (className = (classBinding = fieldBinding.getDeclaringClass()).getQualifiedName()) != null && className.equals(this.fReplacement.substring(0, lastDot))) {
                    sameClass = true;
                }
                IImportDeclaration[] iImportDeclarationArray = importDecls = cuRewrite.getCu().getImports();
                int n = importDecls.length;
                int n2 = 0;
                while (n2 < n) {
                    String importName;
                    int elementLastDot;
                    IImportDeclaration importDecl = iImportDeclarationArray[n2];
                    String elementName = importDecl.getElementName();
                    if (!importDecl.isOnDemand() && (elementLastDot = elementName.lastIndexOf(46)) > 0 && (importName = elementName.substring(elementLastDot + 1)).equals(simpleNameQualifier) && !elementName.equals(this.fReplacement.substring(0, lastDot)) && !this.fReplacement.substring(0, lastDot).equals(packageDecls[0].getElementName())) {
                        mustQualify = !sameClass;
                        break;
                    }
                    ++n2;
                }
            }
            if (mustQualify) {
                Name newName = ast.newName(this.fReplacement);
                rewrite.replace(this.fNode, (ASTNode)newName, null);
            } else if (sameClass) {
                class GetSimpleNameVisitor
                extends ASTVisitor {
                    private SimpleName nameToReplace;

                    GetSimpleNameVisitor() {
                        SimpleName simpleName;
                        ASTNode aSTNode = ReplaceDeprecatedFieldProposalOperation.this.fNode;
                        this.nameToReplace = aSTNode instanceof SimpleName ? (simpleName = (SimpleName)aSTNode) : null;
                    }

                    public boolean visit(SimpleName node) {
                        if (node.getLocationInParent() == FieldAccess.NAME_PROPERTY || node.getLocationInParent() == SuperFieldAccess.NAME_PROPERTY || node.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                            this.nameToReplace = node;
                        }
                        return true;
                    }

                    public SimpleName getNameToReplace() {
                        return this.nameToReplace;
                    }
                }
                GetSimpleNameVisitor visitor = new GetSimpleNameVisitor();
                this.fNode.accept((ASTVisitor)visitor);
                SimpleName nameToReplace = visitor.getNameToReplace();
                SimpleName newName = ast.newSimpleName(this.fReplacement.substring(lastDot + 1));
                rewrite.replace((ASTNode)nameToReplace, (ASTNode)newName, null);
            } else {
                importRewrite.addImport(this.fReplacement.substring(0, lastDot));
                Name newName = ast.newName(this.fReplacement.substring(simpleNameQualifierIndex));
                rewrite.replace(this.fNode, (ASTNode)newName, null);
            }
            importRemover.registerRemovedNode(this.fNode);
        }
    }
}

