/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.checkouts;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutImpl;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceBase;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceConfiguration;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceUtil;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.h2.jdbcx.JdbcDataSource;

public class OfflineCDOCheckout
extends CDOCheckoutImpl {
    public static final String PROP_DIRTY = "dirty";
    private final IListener workspaceListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOWorkspace.DirtyStateChangedEvent) {
                CDOWorkspace.DirtyStateChangedEvent e = (CDOWorkspace.DirtyStateChangedEvent)event;
                OfflineCDOCheckout.this.setDirty(e.isDirty());
                OfflineCDOCheckout.this.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE);
            } else if (event instanceof CDOWorkspace.ObjectStatesChangedEvent) {
                CDOWorkspace.ObjectStatesChangedEvent e = (CDOWorkspace.ObjectStatesChangedEvent)event;
                HashSet<CDOObject> objects = new HashSet<CDOObject>();
                CDOView view = OfflineCDOCheckout.this.getView();
                for (CDOID id : e.getChangedIDs()) {
                    CDOObject object = view.getObject(id, false);
                    if (object == null) continue;
                    objects.add(object);
                }
                OfflineCDOCheckout.this.getManager().fireElementsChangedEvent(objects.toArray());
            }
        }
    };
    private InternalCDOWorkspace workspace;
    private boolean dirty;

    @Override
    public boolean isOffline() {
        return true;
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        throw new IllegalStateException("Checkout is offline: " + this);
    }

    public final InternalCDOWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public final boolean isDirty() {
        if (this.workspace != null) {
            return this.workspace.isDirty();
        }
        return this.dirty;
    }

    public final void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.save();
        }
    }

    public CDOState getState(Object object) {
        if (object == this) {
            return this.isDirty() ? CDOState.DIRTY : CDOState.CLEAN;
        }
        if (this.workspace != null) {
            return this.workspace.getState(object);
        }
        return null;
    }

    public void refresh() {
        this.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.ELEMENT);
    }

    @Override
    public String getBranchPath() {
        if (this.workspace != null) {
            return this.workspace.getBranchPath();
        }
        return super.getBranchPath();
    }

    @Override
    protected String doSetBranchPoint(int branchID, long timeStamp) {
        CDORepository repository = this.getRepository();
        CDOSession session = repository.acquireSession();
        try {
            CDOBranch branch = session.getBranchManager().getBranch(branchID);
            if (branch != null) {
                String branchPath = branch.getPathName();
                this.workspace.replace(branchPath, timeStamp);
                String string = branchPath;
                return string;
            }
        }
        finally {
            repository.releaseSession();
        }
        return null;
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.dirty = Boolean.parseBoolean(properties.getProperty(PROP_DIRTY, "false"));
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_DIRTY, Boolean.toString(this.dirty));
    }

    @Override
    protected CDOView openView(CDOSession session, ResourceSet resourceSet) {
        CDOSessionConfigurationFactory remote = new CDOSessionConfigurationFactory(){

            public CDOSessionConfiguration createSessionConfiguration() {
                return new RemoteSessionConfiguration();
            }
        };
        File folder = this.getFolder();
        File storeFolder = new File(folder, "store");
        File dbPrefix = new File(storeFolder, "db");
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + dbPrefix);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("qualifiedNames", "true");
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true, (boolean)true, (boolean)false);
        mappingStrategy.setProperties(props);
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)"h2");
        IDBConnectionProvider connectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider);
        File baseFolder = new File(folder, "base");
        CDOWorkspaceBase base = CDOWorkspaceUtil.createFolderWorkspaceBase((File)baseFolder);
        String localRepositoryName = String.valueOf(this.getRepository().getName()) + "-workspace" + this.getID();
        int branchID = this.getBranchID();
        long timeStamp = this.getTimeStamp();
        CDOWorkspaceConfiguration configuration = CDOWorkspaceUtil.createWorkspaceConfiguration();
        configuration.setLocalRepositoryName(localRepositoryName);
        configuration.setRemote(remote);
        configuration.setStore((IStore)store);
        configuration.setBase(base);
        if (storeFolder.isDirectory()) {
            this.workspace = (InternalCDOWorkspace)configuration.open();
        } else {
            configuration.setBranchID(branchID);
            configuration.setTimeStamp(timeStamp);
            this.workspace = (InternalCDOWorkspace)configuration.checkout();
        }
        this.setBranchPath(this.workspace.getBranchPath());
        this.setDirty(this.workspace.isDirty());
        this.workspace.addListener(this.workspaceListener);
        return this.workspace.openView(resourceSet);
    }

    @Override
    protected void closeView() {
        super.closeView();
        if (this.workspace != null) {
            this.workspace.close();
            this.workspace = null;
        }
    }

    @Override
    protected CDOView doOpenView(boolean readOnly, ResourceSet resourceSet) {
        if (this.workspace == null) {
            return null;
        }
        if (readOnly) {
            return this.workspace.openView(resourceSet);
        }
        return this.workspace.openTransaction(resourceSet);
    }

    private final class RemoteSessionConfiguration
    implements CDOSessionConfiguration,
    Closeable {
        private boolean closed;

        private RemoteSessionConfiguration() {
        }

        public void addListener(IListener listener) {
        }

        public void removeListener(IListener listener) {
        }

        public boolean hasListeners() {
            return false;
        }

        public IListener[] getListeners() {
            return null;
        }

        public String getUserID() {
            return null;
        }

        public void setUserID(String userID) {
        }

        public boolean isPassiveUpdateEnabled() {
            return false;
        }

        public void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        }

        public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
            return null;
        }

        public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        }

        public CDOCommonSession.Options.LockNotificationMode getLockNotificationMode() {
            return null;
        }

        public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode mode) {
        }

        public CDOSession.ExceptionHandler getExceptionHandler() {
            return null;
        }

        public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        }

        public CDOIDGenerator getIDGenerator() {
            return null;
        }

        public void setIDGenerator(CDOIDGenerator idGenerator) {
        }

        public CDOFetchRuleManager getFetchRuleManager() {
            return null;
        }

        public void setFetchRuleManager(CDOFetchRuleManager fetchRuleManager) {
        }

        public CDOBranchManager getBranchManager() {
            return null;
        }

        public void setBranchManager(CDOBranchManager branchManager) {
        }

        @Deprecated
        public CDOAuthenticator getAuthenticator() {
            return null;
        }

        public IPasswordCredentialsProvider getCredentialsProvider() {
            return null;
        }

        public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
        }

        public byte[] getOneTimeLoginToken() {
            return null;
        }

        public void setOneTimeLoginToken(byte[] oneTimeLoginToken) {
        }

        public boolean isActivateOnOpen() {
            return false;
        }

        public void setActivateOnOpen(boolean activateOnOpen) {
        }

        public boolean isSessionOpen() {
            return !this.closed;
        }

        public CDOSession openSession() {
            CDORepository repository = OfflineCDOCheckout.this.getRepository();
            return repository.acquireSession();
        }

        public void close() {
            if (!this.closed) {
                CDORepository repository = OfflineCDOCheckout.this.getRepository();
                repository.releaseSession();
                this.closed = true;
            }
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

