/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import org.eclipse.dltk.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyLabelProvider;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.internal.ui.callhierarchy.OpenLocationAction;
import org.eclipse.dltk.internal.ui.callhierarchy.TreeRoot;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

class CallHierarchyViewer
extends TreeViewer {
    private CallHierarchyViewPart fPart;
    private OpenLocationAction fOpen;
    private CallHierarchyContentProvider fContentProvider;

    CallHierarchyViewer(Composite parent, CallHierarchyViewPart part) {
        super(new Tree(parent, 2));
        this.fPart = part;
        this.getControl().setLayoutData((Object)new GridData(1808));
        this.setUseHashlookup(true);
        this.setAutoExpandLevel(2);
        this.fContentProvider = new CallHierarchyContentProvider(this.fPart);
        this.setContentProvider((IContentProvider)this.fContentProvider);
        this.setLabelProvider((IBaseLabelProvider)new CallHierarchyLabelProvider());
        this.fOpen = new OpenLocationAction(part, (IWorkbenchSite)part.getSite());
        this.addOpenListener(event -> this.fOpen.run());
        this.clearViewer();
    }

    void setMethodWrapper(MethodWrapper wrapper) {
        this.setInput(this.getTreeRoot(wrapper));
        this.setFocus();
        this.setSelection((ISelection)new StructuredSelection((Object)wrapper), true);
    }

    CallHierarchyViewPart getPart() {
        return this.fPart;
    }

    void setFocus() {
        this.getControl().setFocus();
    }

    boolean isInFocus() {
        return this.getControl().isFocusControl();
    }

    void addKeyListener(KeyListener keyListener) {
        this.getControl().addKeyListener(keyListener);
    }

    private TreeRoot getTreeRoot(MethodWrapper root) {
        TreeRoot dummyRoot = new TreeRoot((Object)root);
        return dummyRoot;
    }

    void initContextMenu(IMenuListener menuListener, IWorkbenchPartSite viewSite, ISelectionProvider selectionProvider) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        viewSite.registerContextMenu(menuMgr, selectionProvider);
    }

    void clearViewer() {
        this.setInput(TreeRoot.EMPTY_ROOT);
    }

    void cancelJobs() {
        if (this.fPart == null) {
            return;
        }
        this.fContentProvider.cancelJobs(this.fPart.getCurrentMethodWrapper());
    }
}

