/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.managers;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.dbgp.IDbgpStreamListener;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.managers.IDbgpStreamManager;
import org.eclipse.dltk.dbgp.internal.packets.DbgpStreamPacket;

public class DbgpStreamManager
extends DbgpWorkingThread
implements IDbgpStreamManager {
    private final ListenerList<IDbgpStreamListener> listeners = new ListenerList();
    private final IDbgpDebugingEngine engine;

    protected void fireStderrReceived(String data) {
        if (data == null || data.length() == 0) {
            return;
        }
        for (IDbgpStreamListener listener : this.listeners) {
            listener.stderrReceived(data);
        }
    }

    protected void fireStdoutReceived(String data) {
        if (data == null || data.length() == 0) {
            return;
        }
        for (IDbgpStreamListener listener : this.listeners) {
            listener.stdoutReceived(data);
        }
    }

    @Override
    protected void workingCycle() throws Exception {
        try {
            while (!Thread.interrupted()) {
                DbgpStreamPacket packet = this.engine.getStreamPacket();
                if (packet.isStderr()) {
                    this.fireStderrReceived(packet.getTextContent());
                    continue;
                }
                if (!packet.isStdout()) continue;
                this.fireStdoutReceived(packet.getTextContent());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public DbgpStreamManager(IDbgpDebugingEngine engine, String name) {
        super(name);
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
    }

    @Override
    public void addListener(IDbgpStreamListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IDbgpStreamListener listener) {
        this.listeners.remove((Object)listener);
    }
}

