/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;

public class BuildpathValidation {
    private ScriptProject project;

    public BuildpathValidation(ScriptProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        IModelStatus status;
        IBuildpathEntry[] rawBuildpath;
        ModelManager.PerProjectInfo perProjectInfo;
        try {
            perProjectInfo = this.project.getPerProjectInfo();
        }
        catch (ModelException e) {
            IProject resource = this.project.getProject();
            if (resource.isAccessible()) {
                this.project.flushBuildpathProblemMarkers(true, true);
                if (DLTKCore.DEBUG) {
                    System.err.println("TODO: BuildpathValidation.java remove problems and tasks created  by the builder");
                }
            }
            return;
        }
        ModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
        synchronized (perProjectInfo2) {
            rawBuildpath = perProjectInfo.rawBuildpath;
            status = perProjectInfo.rawBuildpathStatus;
        }
        this.project.flushBuildpathProblemMarkers(false, true);
        if (status != null && !status.isOK()) {
            this.project.createBuildpathProblemMarker(status);
        }
        this.project.flushBuildpathProblemMarkers(false, false);
        if (rawBuildpath != ScriptProject.INVALID_BUILDPATH && rawBuildpath != null) {
            int i = 0;
            while (i < rawBuildpath.length) {
                status = BuildpathEntry.validateBuildpathEntry(this.project, rawBuildpath[i], true);
                if (!(status.isOK() || status.getCode() == 964 && ((BuildpathEntry)rawBuildpath[i]).isOptional())) {
                    this.project.createBuildpathProblemMarker(status);
                }
                ++i;
            }
            status = BuildpathEntry.validateBuildpath(this.project, rawBuildpath);
            if (!status.isOK()) {
                this.project.createBuildpathProblemMarker(status);
            }
        }
    }
}

