/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.wizard.ExternalDependency;
import org.eclipse.xtext.xtext.wizard.Outlet;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.TextFile;

public class GradleBuildFile
extends TextFile {
    @Accessors
    private String pluginsSection = "";
    @Accessors
    private String additionalContent = "";

    public GradleBuildFile(ProjectDescriptor project) {
        super(Outlet.ROOT, "build.gradle", project);
    }

    @Override
    public String getContent() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(this.pluginsSection);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = IterableExtensions.isEmpty(this.getAllDependencies());
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("dependencies {");
            _builder.newLine();
            Set<? extends ProjectDescriptor> _upstreamProjects = this.getProject().getUpstreamProjects();
            for (ProjectDescriptor projectDescriptor : _upstreamProjects) {
                _builder.append("\t");
                _builder.append("api project(':");
                String _name = projectDescriptor.getName();
                _builder.append(_name, "\t");
                _builder.append("')");
                _builder.newLineIfNotEmpty();
            }
            Iterable<ExternalDependency.MavenCoordinates> _mavenDependencies = this.getMavenDependencies();
            for (ExternalDependency.MavenCoordinates mavenCoordinates : _mavenDependencies) {
                boolean _tripleNotEquals;
                String _version = mavenCoordinates.getVersion();
                boolean bl2 = _tripleNotEquals = _version != null;
                if (_tripleNotEquals) {
                    _builder.append("\t");
                    String _gradleNotation = mavenCoordinates.getScope().getGradleNotation();
                    _builder.append(_gradleNotation, "\t");
                    _builder.append(" \"");
                    String _groupId = mavenCoordinates.getGroupId();
                    _builder.append(_groupId, "\t");
                    _builder.append(":");
                    String _artifactId = mavenCoordinates.getArtifactId();
                    _builder.append(_artifactId, "\t");
                    _builder.append(":");
                    String _version_1 = mavenCoordinates.getVersion();
                    _builder.append(_version_1, "\t");
                    _builder.append("\"");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append("\t");
                String _gradleNotation_1 = mavenCoordinates.getScope().getGradleNotation();
                _builder.append(_gradleNotation_1, "\t");
                _builder.append(" '");
                String _groupId_1 = mavenCoordinates.getGroupId();
                _builder.append(_groupId_1, "\t");
                _builder.append(":");
                String _artifactId_1 = mavenCoordinates.getArtifactId();
                _builder.append(_artifactId_1, "\t");
                _builder.append("'");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append(this.additionalContent);
        _builder.newLineIfNotEmpty();
        boolean _isEclipsePluginProject = this.getProject().isEclipsePluginProject();
        if (_isEclipsePluginProject) {
            _builder.append("//this is an eclipse plugin project");
            _builder.newLine();
            _builder.append("eclipseClasspath.enabled=false");
            _builder.newLine();
            _builder.append("cleanEclipseClasspath.enabled=false");
            _builder.newLine();
        }
        return _builder.toString();
    }

    private Iterable<ExternalDependency.MavenCoordinates> getMavenDependencies() {
        Functions.Function1 _function = it -> it.getMaven();
        Functions.Function1 _function_1 = it -> {
            String _artifactId = it.getArtifactId();
            return _artifactId != null;
        };
        return IterableExtensions.filter((Iterable)IterableExtensions.map(this.getProject().getExternalDependencies(), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    private Iterable<Object> getAllDependencies() {
        Set<? extends ProjectDescriptor> _upstreamProjects = this.getProject().getUpstreamProjects();
        Iterable<ExternalDependency.MavenCoordinates> _mavenDependencies = this.getMavenDependencies();
        return Iterables.concat(_upstreamProjects, _mavenDependencies);
    }

    @Pure
    public String getPluginsSection() {
        return this.pluginsSection;
    }

    public void setPluginsSection(String pluginsSection) {
        this.pluginsSection = pluginsSection;
    }

    @Pure
    public String getAdditionalContent() {
        return this.additionalContent;
    }

    public void setAdditionalContent(String additionalContent) {
        this.additionalContent = additionalContent;
    }
}

