/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel;

import org.apache.wsil.Link;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilLinkElement;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.util.DiscoveryURL;

public class WsilUddiBusinessElement
extends WsilLinkElement {
    private BusinessEntity busEntity_ = null;

    public WsilUddiBusinessElement(String name, Model model, Link link) {
        super(name, model, link);
    }

    public void setServiceProvider(BusinessEntity be) {
        this.busEntity_ = be;
    }

    public BusinessEntity getServiceProvider() {
        return this.busEntity_;
    }

    public String getName() {
        return this.busEntity_ == null ? null : this.busEntity_.getDefaultNameString();
    }

    public String getDescription() {
        return this.busEntity_ == null ? null : this.busEntity_.getDefaultDescriptionString();
    }

    public String getUDDILinkInquiryAPI() {
        BusinessDescription bd = this.getValidUDDIBusinessDescription();
        return bd == null ? null : bd.getLocation();
    }

    public String getUDDILinkBusinessKey() {
        BusinessDescription bd = this.getValidUDDIBusinessDescription();
        return bd == null ? null : bd.getBusinessKey().getText();
    }

    public String getUDDILinkDiscoveryURL() {
        BusinessDescription bd = this.getValidUDDIBusinessDescription();
        if (bd == null) {
            return null;
        }
        DiscoveryURL discoveryURL = bd.getDiscoveryURL();
        return discoveryURL == null ? null : discoveryURL.getText();
    }

    public boolean validateUDDILink() {
        BusinessDescription bd = this.getValidUDDIBusinessDescription();
        return bd != null;
    }

    private BusinessDescription getValidUDDIBusinessDescription() {
        ExtensionElement extElement = this.link_.getExtensionElement();
        if (!(extElement instanceof BusinessDescription)) {
            return null;
        }
        String inquiryAPI = ((BusinessDescription)extElement).getLocation();
        if (!Validator.validateURL(inquiryAPI)) {
            return null;
        }
        String businessKey = ((BusinessDescription)extElement).getBusinessKey().getText();
        if (businessKey == null || businessKey.length() <= 0) {
            return null;
        }
        return (BusinessDescription)extElement;
    }

    public String toString() {
        return this.getName();
    }
}

