/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.ui.internal.contentassist.ProposalComparator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class ContentAssistRequest {
    protected IStructuredDocumentRegion documentRegion = null;
    protected List macros = new ArrayList();
    protected String matchString;
    protected IJSONNode node = null;
    protected IJSONNode parent = null;
    protected List proposals = new ArrayList();
    protected ITextRegion region = null;
    protected int replacementBeginPosition;
    protected int replacementLength;

    public ContentAssistRequest(IJSONNode node, IJSONNode parent, IStructuredDocumentRegion documentRegion, ITextRegion completionRegion, int begin, int length, String filter) {
        this.setNode(node);
        this.setParent(parent);
        this.setDocumentRegion(documentRegion);
        this.setRegion(completionRegion);
        this.setMatchString(filter);
        this.setReplacementBeginPosition(begin);
        this.setReplacementLength(length);
    }

    public void addMacro(ICompletionProposal newProposal) {
        this.macros.add(newProposal);
    }

    public void addProposal(ICompletionProposal newProposal) {
        this.proposals.add(newProposal);
    }

    public ICompletionProposal[] getCompletionProposals() {
        ICompletionProposal[] results = null;
        if (this.getProposals().size() > 0 || this.getMacros().size() > 0) {
            List allProposals = new ArrayList();
            if (!this.shouldSeparate()) {
                allProposals.addAll(this.getProposals());
                allProposals.addAll(this.getMacros());
                allProposals = this.sortProposals(allProposals);
            } else {
                allProposals.addAll(this.sortProposals(this.getProposals()));
                allProposals.addAll(this.sortProposals(this.getMacros()));
            }
            results = new ICompletionProposal[allProposals.size()];
            int i = 0;
            while (i < allProposals.size()) {
                results[i] = (ICompletionProposal)allProposals.get(i);
                ++i;
            }
        }
        return results;
    }

    public IStructuredDocumentRegion getDocumentRegion() {
        return this.documentRegion;
    }

    public List getMacros() {
        return this.macros;
    }

    public String getMatchString() {
        return this.matchString;
    }

    public IJSONNode getNode() {
        return this.node;
    }

    public IJSONNode getParent() {
        return this.parent;
    }

    public List getProposals() {
        return this.proposals;
    }

    public ITextRegion getRegion() {
        return this.region;
    }

    public int getReplacementBeginPosition() {
        return this.replacementBeginPosition;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public int getStartOffset() {
        if (this.getDocumentRegion() != null && this.getRegion() != null) {
            return this.getDocumentRegion().getStartOffset(this.getRegion());
        }
        return -1;
    }

    public String getText() {
        if (this.getDocumentRegion() != null && this.getRegion() != null) {
            return this.getDocumentRegion().getText(this.getRegion());
        }
        return "";
    }

    public int getTextEndOffset() {
        if (this.getDocumentRegion() != null && this.getRegion() != null) {
            return this.getDocumentRegion().getTextEndOffset(this.getRegion());
        }
        return -1;
    }

    public void setDocumentRegion(IStructuredDocumentRegion region) {
        this.documentRegion = region;
    }

    public void setMatchString(String newMatchString) {
        this.matchString = newMatchString;
    }

    public void setNode(IJSONNode newNode) {
        this.node = newNode;
    }

    public void setParent(IJSONNode newParent) {
        this.parent = newParent;
    }

    public void setRegion(ITextRegion newRegion) {
        this.region = newRegion;
    }

    public void setReplacementBeginPosition(int newReplacementBeginPosition) {
        this.replacementBeginPosition = newReplacementBeginPosition;
    }

    public void setReplacementLength(int newReplacementLength) {
        this.replacementLength = newReplacementLength;
    }

    public boolean shouldSeparate() {
        return false;
    }

    protected List sortProposals(List proposalsIn) {
        Collections.sort(proposalsIn, new ProposalComparator());
        return proposalsIn;
    }

    public String toString() {
        return "Node: " + String.valueOf(this.getNode()) + "\nParent: " + String.valueOf(this.getParent()) + "\nStructuredDocumentRegion: " + StringUtils.escape((String)this.getDocumentRegion().toString()) + "\nRegion: " + String.valueOf(this.getRegion()) + "\nMatch string: '" + StringUtils.escape((String)this.getMatchString()) + "'\nOffsets: [" + this.getReplacementBeginPosition() + "-" + (this.getReplacementBeginPosition() + this.getReplacementLength()) + "]\n";
    }
}

