/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumExceptionBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ValueBase;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.ui.Messages;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class JsDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof DebugTargetImpl) {
            DebugTargetImpl debugTargetImpl = (DebugTargetImpl)element;
            WorkspaceBridge.JsLabelProvider labelProvider = debugTargetImpl.getLabelProvider();
            try {
                return labelProvider.getTargetLabel(debugTargetImpl);
            }
            catch (DebugException e) {
                ChromiumDebugPlugin.log((Throwable)new Exception("Failed to read debug target label", e));
                return null;
            }
        }
        if (element instanceof IBreakpoint) {
            IBreakpoint breakpoint = (IBreakpoint)element;
            ChromiumExceptionBreakpoint exceptionBreakpoint = ChromiumExceptionBreakpoint.tryCastBreakpoint((IBreakpoint)breakpoint);
            if (exceptionBreakpoint != null) {
                String caughtAddendum = exceptionBreakpoint.getIncludeCaught() ? Messages.JsDebugModelPresentation_EXCEPTION_LABEL_CAUGHT_ADDENDUM : "";
                return NLS.bind((String)Messages.JsDebugModelPresentation_EXCEPTION_LABEL, (Object)caughtAddendum);
            }
            return null;
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        ValueBase chromiumValue = ValueBase.cast((IValue)value);
        if (chromiumValue == null) {
            String detail = BasicUtil.getStacktraceString((Exception)new Exception("Unexpected type of value: " + value));
            listener.detailComputed(value, detail);
            return;
        }
        Value realValue = chromiumValue.asRealValue();
        if (realValue == null) {
            String detail = chromiumValue.getValueString();
            listener.detailComputed(value, detail);
            return;
        }
        realValue.computeDetailAsync(listener);
    }

    public IEditorInput getEditorInput(Object element) {
        return JsDebugModelPresentation.toEditorInput(element);
    }

    public static IEditorInput toEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IFile file;
        if (element instanceof IFile) {
            file = (IFile)element;
        } else if (element instanceof IBreakpoint) {
            IBreakpoint breakpoint = (IBreakpoint)element;
            IResource resource = breakpoint.getMarker().getResource();
            if (!(resource instanceof IFile)) {
                return null;
            }
            file = (IFile)resource;
        } else {
            return null;
        }
        try {
            return IDE.getEditorDescriptor((IFile)file).getId();
        }
        catch (PartInitException partInitException) {
            return "org.eclipse.wst.jsdt.chromium.debug.ui.editors.JsEditor";
        }
    }
}

