/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class SelectionActionsSupport<C extends ControlInfo>
extends ObjectEventListener {
    private final IGridLayoutInfo<C> m_layout;

    public SelectionActionsSupport(IGridLayoutInfo<C> layout) {
        this.m_layout = layout;
        this.m_layout.addBroadcastListener((Object)this);
    }

    public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<IGridDataInfo> dataInfos = new ArrayList<IGridDataInfo>();
        List controls = this.m_layout.getControls();
        for (ObjectInfo object : objects) {
            if (!controls.contains(object)) {
                return;
            }
            ControlInfo control = (ControlInfo)object;
            dataInfos.add(this.m_layout.getGridData2(control));
        }
        actions.add(new Separator());
        this.addAlignmentAction(actions, dataInfos, true, CoreImages.ALIGNMENT_H_MENU_LEFT, ModelMessages.SelectionActionsSupport_horLeft, 16384);
        this.addAlignmentAction(actions, dataInfos, true, CoreImages.ALIGNMENT_H_MENU_CENTER, ModelMessages.SelectionActionsSupport_horCenter, 0x1000000);
        this.addAlignmentAction(actions, dataInfos, true, CoreImages.ALIGNMENT_H_MENU_RIGHT, ModelMessages.SelectionActionsSupport_horRight, 131072);
        this.addAlignmentAction(actions, dataInfos, true, CoreImages.ALIGNMENT_H_MENU_FILL, ModelMessages.SelectionActionsSupport_horFill, 4);
        actions.add(new Separator());
        this.addAlignmentAction(actions, dataInfos, false, CoreImages.ALIGNMENT_V_MENU_TOP, ModelMessages.SelectionActionsSupport_verTop, 128);
        this.addAlignmentAction(actions, dataInfos, false, CoreImages.ALIGNMENT_V_MENU_CENTER, ModelMessages.SelectionActionsSupport_verCenter, 0x1000000);
        this.addAlignmentAction(actions, dataInfos, false, CoreImages.ALIGNMENT_V_MENU_BOTTOM, ModelMessages.SelectionActionsSupport_verBottom, 1024);
        this.addAlignmentAction(actions, dataInfos, false, CoreImages.ALIGNMENT_V_MENU_FILL, ModelMessages.SelectionActionsSupport_verFill, 4);
        actions.add(new Separator());
        this.addGrabAction(actions, dataInfos, true, CoreImages.ALIGNMENT_H_MENU_GROW, ModelMessages.SelectionActionsSupport_horGrab);
        this.addGrabAction(actions, dataInfos, false, CoreImages.ALIGNMENT_V_MENU_GROW, ModelMessages.SelectionActionsSupport_verGrab);
    }

    private void addAlignmentAction(List<Object> actions, List<IGridDataInfo> dataInfos, boolean horizontal, ImageDescriptor icon, String tooltip, int alignment) {
        boolean isChecked = true;
        for (IGridDataInfo gridData : dataInfos) {
            if (horizontal) {
                if (gridData.getHorizontalAlignment() == alignment) continue;
                isChecked = false;
                break;
            }
            if (gridData.getVerticalAlignment() == alignment) continue;
            isChecked = false;
            break;
        }
        AlignmentAction action = new AlignmentAction(dataInfos, horizontal, icon, tooltip, isChecked, alignment);
        actions.add((Object)action);
    }

    private void addGrabAction(List<Object> actions, List<IGridDataInfo> dataInfos, boolean horizontal, ImageDescriptor icon, String tooltip) {
        boolean isChecked = true;
        for (IGridDataInfo gridData : dataInfos) {
            if (horizontal) {
                if (gridData.getHorizontalGrab()) continue;
                isChecked = false;
                break;
            }
            if (gridData.getVerticalGrab()) continue;
            isChecked = false;
            break;
        }
        GrabAction action = new GrabAction(dataInfos, horizontal, icon, tooltip, isChecked, !isChecked);
        actions.add((Object)action);
    }

    private abstract class AbstractAction
    extends ObjectInfoAction {
        private final List<IGridDataInfo> m_dataInfos;
        private final boolean m_horizontal;

        public AbstractAction(int style, List<IGridDataInfo> dataInfos, boolean horizontal, ImageDescriptor icon, String tooltip, boolean checked) {
            super(SelectionActionsSupport.this.m_layout.getUnderlyingModel(), "", style);
            this.m_dataInfos = dataInfos;
            this.m_horizontal = horizontal;
            this.setImageDescriptor(icon);
            this.setToolTipText(tooltip);
            this.setChecked(checked);
        }

        protected void runEx() throws Exception {
            for (IGridDataInfo gridData : this.m_dataInfos) {
                if (this.m_horizontal) {
                    this.handleHorizontal(gridData);
                    continue;
                }
                this.handleVertical(gridData);
            }
        }

        protected abstract void handleHorizontal(IGridDataInfo var1) throws Exception;

        protected abstract void handleVertical(IGridDataInfo var1) throws Exception;
    }

    private class AlignmentAction
    extends AbstractAction {
        private final int m_alignment;

        public AlignmentAction(List<IGridDataInfo> dataInfos, boolean horizontal, ImageDescriptor icon, String tooltip, boolean checked, int alignment) {
            super(8, dataInfos, horizontal, icon, tooltip, checked);
            this.m_alignment = alignment;
        }

        @Override
        protected void handleHorizontal(IGridDataInfo gridData) throws Exception {
            gridData.setHorizontalAlignment(this.m_alignment);
        }

        @Override
        protected void handleVertical(IGridDataInfo gridData) throws Exception {
            gridData.setVerticalAlignment(this.m_alignment);
        }
    }

    private class GrabAction
    extends AbstractAction {
        private final boolean m_grab;

        public GrabAction(List<IGridDataInfo> dataInfos, boolean horizontal, ImageDescriptor icon, String tooltip, boolean checked, boolean grab) {
            super(2, dataInfos, horizontal, icon, tooltip, checked);
            this.m_grab = grab;
        }

        @Override
        protected void handleHorizontal(IGridDataInfo gridData) throws Exception {
            gridData.setHorizontalGrab(this.m_grab);
        }

        @Override
        protected void handleVertical(IGridDataInfo gridData) throws Exception {
            gridData.setVerticalGrab(this.m_grab);
        }
    }
}

