/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public final class TabFolderDecorator {
    private final IWorkbenchPart m_hostPart;
    private final CTabFolder m_tabFolder;
    private boolean m_shellActive = true;
    private final IPartListener m_partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part == TabFolderDecorator.this.m_hostPart) {
                TabFolderDecorator.this.updateColors();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == TabFolderDecorator.this.m_hostPart) {
                TabFolderDecorator.this.updateColors();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private final ShellListener m_shellListener = new ShellAdapter(){

        public void shellActivated(ShellEvent e) {
            TabFolderDecorator.this.m_shellActive = true;
            TabFolderDecorator.this.updateColors();
        }

        public void shellDeactivated(ShellEvent e) {
            TabFolderDecorator.this.m_shellActive = false;
            TabFolderDecorator.this.updateColors();
        }
    };

    public static void decorate(IWorkbenchPart hostPart, CTabFolder tabFolder) {
        new TabFolderDecorator(hostPart, tabFolder);
    }

    private TabFolderDecorator(IWorkbenchPart hostPart, CTabFolder tabFolder) {
        this.m_hostPart = hostPart;
        this.m_tabFolder = tabFolder;
        final IWorkbenchPage activePage = this.m_hostPart.getSite().getPage();
        activePage.addPartListener(this.m_partListener);
        final Shell shell = this.m_tabFolder.getShell();
        shell.addShellListener(this.m_shellListener);
        this.m_tabFolder.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                activePage.removePartListener(TabFolderDecorator.this.m_partListener);
                shell.removeShellListener(TabFolderDecorator.this.m_shellListener);
            }
        });
        this.updateColors();
    }

    private void updateColors() {
        if (this.m_hostPart.getSite().getPage().getActivePart() == this.m_hostPart) {
            this.setActiveTabColors();
        } else {
            this.setInactiveTabColors();
        }
    }

    private void setInactiveTabColors() {
        TabFolderDecorator.setInactiveTabColors(this.m_tabFolder);
    }

    private void setActiveTabColors() {
        TabFolderDecorator.setActiveTabColors(this.m_shellActive, this.m_tabFolder);
    }

    public static void setInactiveTabColors(CTabFolder tabFolder) {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        TabFolderDecorator.drawGradient(tabFolder, colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END")}, new int[]{theme.getInt("org.eclipse.ui.workbench.INACTIVE_TAB_PERCENT")}, theme.getBoolean("org.eclipse.ui.workbench.INACTIVE_TAB_VERTICAL"));
    }

    public static void setActiveTabColors(boolean shellActive, CTabFolder tabFolder) {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        if (shellActive) {
            if (tabFolder.getItemCount() == 0) {
                tabFolder.setSelectionBackground(colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END"));
            }
            TabFolderDecorator.drawGradient(tabFolder, colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END")}, new int[]{theme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT")}, theme.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL"));
        } else {
            TabFolderDecorator.drawGradient(tabFolder, colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START"), colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_END")}, new int[]{theme.getInt("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_PERCENT")}, theme.getBoolean("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_VERTICAL"));
        }
    }

    private static void drawGradient(CTabFolder tabFolder, Color fgColor, Color[] bgColors, int[] percentages, boolean vertical) {
        if (!tabFolder.isDisposed()) {
            tabFolder.setSelectionForeground(fgColor);
            tabFolder.setSelectionBackground(bgColors, percentages, vertical);
        }
    }
}

