/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding.editors.controls;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class AbstractControlActionsManager {
    protected final Object[] COMMAND_HANDLER_IDS = new Object[]{"org.eclipse.ui.edit.copy", "org.eclipse.ui.edit.cut", "org.eclipse.ui.edit.paste", "org.eclipse.ui.edit.delete", "org.eclipse.ui.edit.selectAll", "org.eclipse.ui.edit.undo", "org.eclipse.ui.edit.redo"};
    protected final Control m_control;
    private boolean m_active = false;
    protected static final IHandler EMPTY_HANDLER = new AbstractHandler(){

        public Object execute(ExecutionEvent event) throws ExecutionException {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isHandled() {
            return false;
        }
    };
    private final List<IHandlerActivation> m_activations = new LinkedList<IHandlerActivation>();

    public AbstractControlActionsManager(Control control) {
        this.m_control = control;
        this.m_control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractControlActionsManager.this.activateHandlers();
                AbstractControlActionsManager.this.m_active = true;
            }

            public void focusLost(FocusEvent e) {
                AbstractControlActionsManager.this.deactivateHandlers();
                AbstractControlActionsManager.this.m_active = false;
            }
        });
        this.m_control.addDisposeListener(e -> {
            if (this.m_active) {
                this.deactivateHandlers();
            }
        });
    }

    public static IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    protected void activateHandlers() {
        IHandlerService service = AbstractControlActionsManager.getHandlerService();
        int i = 0;
        while (i < this.COMMAND_HANDLER_IDS.length) {
            String actionName = (String)this.COMMAND_HANDLER_IDS[i];
            IHandler handler = this.getHandlerFor(actionName);
            this.activateHandler(actionName, service, handler, new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    return EvaluationResult.TRUE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.markSystemPropertyAccessed();
                    info.markDefaultVariableAccessed();
                    info.addVariableNameAccess("activeMenu");
                }
            });
            ++i;
        }
    }

    protected IHandler getHandlerFor(String actionName) {
        return EMPTY_HANDLER;
    }

    private void activateHandler(String actionName, IHandlerService service, IHandler handler, Expression highPriorityExpression) {
        this.m_activations.add(service.activateHandler(actionName, handler, highPriorityExpression));
    }

    protected void deactivateHandlers() {
        AbstractControlActionsManager.getHandlerService().deactivateHandlers(this.m_activations);
        this.m_activations.clear();
    }
}

