/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect.description;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.description.CellEditorTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionFactory;
import org.eclipse.sirius.table.metamodel.table.description.LabelEditTool;
import org.eclipse.sirius.table.metamodel.table.description.TableCreationDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableNavigationDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.metamodel.table.description.TableVariable;
import org.eclipse.sirius.table.metamodel.table.description.util.DescriptionSwitch;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.viewpoint.description.tool.ContainerViewVariable;
import org.eclipse.sirius.viewpoint.description.tool.ElementSelectVariable;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.NameVariable;
import org.eclipse.sirius.viewpoint.description.tool.ToolFactory;

public class TableToolVariables
extends DescriptionSwitch<Object> {
    private static final Map<String, String> DOCUMENTATIONS = new HashMap<String, String>();
    private static final List<String> AXIS_VARIABLE_NAMES;

    static {
        DOCUMENTATIONS.put("table", Messages.TableToolVariables_TableElement);
        DOCUMENTATIONS.put("root", Messages.TableToolVariables_SemanticRootElement);
        DOCUMENTATIONS.put("containerView", Messages.TableToolVariables_ContainerView);
        DOCUMENTATIONS.put("container", Messages.TableToolVariables_SemanticElementOfContainerView);
        DOCUMENTATIONS.put("view", Messages.TableToolVariables_CurrentViewElement);
        DOCUMENTATIONS.put("element", Messages.TableToolVariables_CurrentSemanticElement);
        DOCUMENTATIONS.put("line", Messages.TableToolVariables_LineElement);
        DOCUMENTATIONS.put("lineSemantic", Messages.TableToolVariables_SemanticLineElement);
        DOCUMENTATIONS.put("column", Messages.TableToolVariables_ColumnElement);
        DOCUMENTATIONS.put("columnSemantic", Messages.TableToolVariables_SemanticColumnElement);
        DOCUMENTATIONS.put("cellEditorResult", Messages.TableToolVariables_CellEditorResult);
        AXIS_VARIABLE_NAMES = Arrays.asList("table", "root", "containerView", "container", "view", "element");
    }

    public Object caseCreateCellTool(CreateCellTool object) {
        this.addCellVariables((TableTool)object);
        return super.caseCreateCellTool(object);
    }

    public Object caseCreateTool(CreateTool object) {
        AXIS_VARIABLE_NAMES.forEach(name -> this.addVariableDescriptor((TableTool)object, (String)name));
        return super.caseCreateTool(object);
    }

    public Object caseLabelEditTool(LabelEditTool object) {
        this.addVariableDescriptor((TableTool)object, "element");
        this.addCellVariables((TableTool)object);
        return super.caseLabelEditTool(object);
    }

    public Object caseCellEditorTool(CellEditorTool object) {
        this.addVariableDescriptor((TableTool)object, "element");
        this.addCellVariables((TableTool)object);
        this.addVariableDescriptor((TableTool)object, "cellEditorResult");
        return super.caseCellEditorTool(object);
    }

    public Object caseDeleteTool(DeleteTool object) {
        AXIS_VARIABLE_NAMES.forEach(name -> this.addVariableDescriptor((TableTool)object, (String)name));
        return super.caseDeleteTool(object);
    }

    public Object caseTableCreationDescription(TableCreationDescription object) {
        ContainerViewVariable containerViewVariable = ToolFactory.eINSTANCE.createContainerViewVariable();
        containerViewVariable.setName("containerView");
        object.setContainerViewVariable(containerViewVariable);
        NameVariable tableNameVariable = ToolFactory.eINSTANCE.createNameVariable();
        tableNameVariable.setName("tableName");
        object.setRepresentationNameVariable(tableNameVariable);
        InitialOperation initialOperation = ToolFactory.eINSTANCE.createInitialOperation();
        object.setInitialOperation(initialOperation);
        return super.caseTableCreationDescription(object);
    }

    public Object caseTableNavigationDescription(TableNavigationDescription object) {
        ContainerViewVariable containerViewVariable = ToolFactory.eINSTANCE.createContainerViewVariable();
        containerViewVariable.setName("containerView");
        object.setContainerViewVariable(containerViewVariable);
        ElementSelectVariable containerVariable = ToolFactory.eINSTANCE.createElementSelectVariable();
        containerVariable.setName("container");
        object.setContainerVariable(containerVariable);
        NameVariable tableNameVariable = ToolFactory.eINSTANCE.createNameVariable();
        tableNameVariable.setName("tableName");
        object.setRepresentationNameVariable(tableNameVariable);
        return super.caseTableNavigationDescription(object);
    }

    private void addCellVariables(TableTool object) {
        this.addVariableDescriptor(object, "table");
        this.addVariableDescriptor(object, "root");
        this.addVariableDescriptor(object, "line");
        this.addVariableDescriptor(object, "lineSemantic");
        this.addVariableDescriptor(object, "column");
        this.addVariableDescriptor(object, "columnSemantic");
    }

    private void addVariableDescriptor(TableTool tool, String name) {
        if (TableHelper.getVariable(tool, name) == null) {
            TableVariable newVar = DescriptionFactory.eINSTANCE.createTableVariable();
            newVar.setName(name);
            newVar.setDocumentation(DOCUMENTATIONS.get(name));
            tool.getVariables().add((Object)newVar);
        }
    }
}

