/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FolderSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.build.AddLibraryDialog;
import org.eclipse.pde.internal.ui.editor.build.BuildUtil;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.pde.internal.ui.wizards.RenameDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RuntimeInfoSection
extends PDESection
implements IBuildPropertiesConstants {
    private static final int F_NEW_INDEX = 0;
    private static final int F_UP_UNDEX = 2;
    private static final int F_DOWN_INDEX = 3;
    protected TableViewer fLibraryViewer;
    protected TableViewer fFolderViewer;
    protected StructuredViewerPart fLibraryPart;
    protected StructuredViewerPart fFolderPart;
    private boolean fEnabled = true;

    public RuntimeInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEUIMessages.BuildEditor_RuntimeInfoSection_title);
        this.getSection().setDescription(PDEUIMessages.BuildEditor_RuntimeInfoSection_desc);
        IBuildModel model = this.getBuildModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.getSection().addDisposeListener(e -> model.removeModelChangedListener((IModelChangedListener)this));
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.getPage().getPDEEditor().getContextManager().findContext("build-context");
        if (context == null) {
            return null;
        }
        return (IBuildModel)context.getModel();
    }

    protected void handleLibInBinBuild(boolean isSelected, String libName) {
        IBuildModel model = this.getBuildModel();
        IBuildEntry binIncl = model.getBuild().getEntry("bin.includes");
        IProject project = model.getUnderlyingResource().getProject();
        IPath libPath = libName.equals(".") ? null : project.getFile(libName).getProjectRelativePath();
        try {
            if (binIncl == null && !isSelected) {
                return;
            }
            if (binIncl == null) {
                binIncl = model.getFactory().createEntry("bin.includes");
                model.getBuild().add(binIncl);
            }
            if (libPath != null) {
                if (!isSelected && libPath.segmentCount() == 1 && binIncl.contains("*.jar")) {
                    this.addAllJarsToBinIncludes(binIncl, project, model);
                } else if (!isSelected && libPath.segmentCount() > 1) {
                    IPath parent = libPath.removeLastSegments(1);
                    String parentPath = parent.toString() + "/";
                    if (binIncl.contains(parentPath) && !project.exists(parent)) {
                        binIncl.removeToken(parentPath);
                    } else if (parent.segmentCount() > 1 && binIncl.contains(parentPath = (parent = parent.removeLastSegments(1)).toString() + "/") && !project.exists(parent)) {
                        binIncl.removeToken(parentPath);
                    }
                }
            }
            if (isSelected && !binIncl.contains(libName)) {
                binIncl.addToken(libName);
            } else if (!isSelected && binIncl.contains(libName)) {
                binIncl.removeToken(libName);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void addAllJarsToBinIncludes(IBuildEntry binIncl, IProject project, IBuildModel model) {
        try {
            IResource[] members = project.members();
            int i = 0;
            while (i < members.length) {
                if (!(members[i] instanceof IFolder) && members[i].getFileExtension().equals("jar")) {
                    binIncl.addToken(members[i].getName());
                }
                ++i;
            }
            IBuildEntry[] libraries = BuildUtil.getBuildLibraries(model.getBuild().getBuildEntries());
            if (libraries.length != 0) {
                IBuildEntry[] iBuildEntryArray = libraries;
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildEntry library = iBuildEntryArray[n2];
                    String libraryName = library.getName().substring(7);
                    IPath path = project.getFile(libraryName).getProjectRelativePath();
                    if (path.segmentCount() == 1 && !binIncl.contains(libraryName)) {
                        binIncl.addToken(libraryName);
                    }
                    ++n2;
                }
            }
            binIncl.removeToken("*.jar");
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setOutputEntryTokens(Set<String> outputFolders, IBuildEntry outputEntry) {
        Iterator<String> iter = outputFolders.iterator();
        try {
            while (iter.hasNext()) {
                String outputFolder = iter.next().toString();
                if (!outputFolder.endsWith("/")) {
                    outputFolder = outputFolder.concat("/");
                }
                if (outputEntry.contains(outputFolder.toString())) continue;
                outputEntry.addToken(outputFolder.toString());
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPackageFragmentRoot[] computeSourceFolders() {
        ArrayList<IPackageFragmentRoot> folders = new ArrayList<IPackageFragmentRoot>();
        IBuildModel buildModel = this.getBuildModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IPackageFragmentRoot[] roots;
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jProject.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                    if (fragmentRoot.getKind() == 1) {
                        folders.add(fragmentRoot);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return folders.toArray(new IPackageFragmentRoot[folders.size()]);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        this.createLeftSection(container, toolkit);
        this.createRightSection(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setClient((Control)container);
    }

    private void createLeftSection(Composite parent, FormToolkit toolkit) {
        Composite container = this.createContainer(parent, toolkit);
        String[] stringArray = new String[4];
        stringArray[0] = PDEUIMessages.BuildEditor_RuntimeInfoSection_addLibrary;
        stringArray[2] = PDEUIMessages.ManifestEditor_LibrarySection_up;
        stringArray[3] = PDEUIMessages.ManifestEditor_LibrarySection_down;
        this.fLibraryPart = new PartAdapter(stringArray);
        this.fLibraryPart.createControl(container, 65536, 2, toolkit);
        this.fLibraryViewer = (TableViewer)this.fLibraryPart.getViewer();
        this.fLibraryViewer.setContentProvider((IContentProvider)new LibraryContentProvider());
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryPart.setButtonEnabled(2, false);
        this.fLibraryPart.setButtonEnabled(3, false);
        this.fLibraryViewer.setInput((Object)this.getBuildModel());
        toolkit.paintBordersFor(container);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillLibraryContextMenu);
        this.fLibraryViewer.getControl().setMenu(menuMgr.createContextMenu(this.fLibraryViewer.getControl()));
    }

    private void createRightSection(Composite parent, FormToolkit toolkit) {
        Composite container = this.createContainer(parent, toolkit);
        this.fFolderPart = new PartAdapter(this, new String[]{PDEUIMessages.BuildEditor_RuntimeInfoSection_addFolder}){

            @Override
            public void selectionChanged(IStructuredSelection selection) {
            }
        };
        this.fFolderPart.createControl(container, 65536, 2, toolkit);
        this.fFolderViewer = (TableViewer)this.fFolderPart.getViewer();
        this.fFolderViewer.setContentProvider((IContentProvider)new FolderContentProvider());
        this.fFolderViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
        toolkit.paintBordersFor(container);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillFolderViewerContextMenu);
        this.fFolderViewer.getControl().setMenu(menuMgr.createContextMenu(this.fFolderViewer.getControl()));
    }

    private Composite createContainer(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        container.setLayoutData((Object)gd);
        return container;
    }

    protected void fillFolderViewerContextMenu(IMenuManager manager) {
        final IStructuredSelection selection = this.fFolderViewer.getStructuredSelection();
        IStructuredSelection libSelection = this.fLibraryViewer.getStructuredSelection();
        if (libSelection != null && !libSelection.isEmpty()) {
            Action newAction = new Action(PDEUIMessages.BuildEditor_RuntimeInfoSection_popupFolder){

                public void run() {
                    RuntimeInfoSection.this.handleNewFolder();
                }
            };
            newAction.setEnabled(this.fEnabled);
            manager.add((IAction)newAction);
        }
        manager.add((IContributionItem)new Separator());
        Action replace = new Action(PDEUIMessages.RuntimeInfoSection_replace){

            public void run() {
                RuntimeInfoSection.this.handleRenameFolder(selection.getFirstElement().toString());
            }
        };
        replace.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)replace);
        Action deleteAction = new Action(PDEUIMessages.Actions_delete_label){

            public void run() {
                RuntimeInfoSection.this.handleDeleteFolder();
            }
        };
        deleteAction.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)deleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    protected void fillLibraryContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.fLibraryViewer.getStructuredSelection();
        Action newAction = new Action(PDEUIMessages.BuildEditor_RuntimeInfoSection_popupAdd){

            public void run() {
                RuntimeInfoSection.this.handleNew();
            }
        };
        newAction.setEnabled(this.fEnabled);
        manager.add((IAction)newAction);
        manager.add((IContributionItem)new Separator());
        Action renameAction = new Action(PDEUIMessages.EditableTablePart_renameAction){

            public void run() {
                RuntimeInfoSection.this.doRename();
            }
        };
        renameAction.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)renameAction);
        Action deleteAction = new Action(PDEUIMessages.Actions_delete_label){

            public void run() {
                RuntimeInfoSection.this.handleDelete();
            }
        };
        deleteAction.setEnabled(!selection.isEmpty() && this.fEnabled);
        manager.add((IAction)deleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    protected void entryModified(IBuildEntry oldEntry, String newValue) {
        IBuildEntry entry = oldEntry;
        IBuildModel buildModel = this.getBuildModel();
        IBuild build = buildModel.getBuild();
        String oldName = entry.getName().substring(7);
        try {
            if (((String)newValue).equals(entry.getName())) {
                return;
            }
            if (!((String)newValue).startsWith("source.")) {
                newValue = "source." + (String)newValue;
            }
            if (!(((String)newValue).endsWith(".jar") || ((String)newValue).endsWith("/") || ((String)newValue).equals("source.."))) {
                newValue = (String)newValue + "/";
            }
            String newName = ((String)newValue).substring(7);
            IBuildEntry tempEntry = build.getEntry("jars.compile.order");
            if (tempEntry != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newName);
            }
            if ((tempEntry = build.getEntry("output." + oldName)) != null) {
                tempEntry.setName("output." + newName);
            }
            if ((tempEntry = build.getEntry("bin.includes")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newName);
            }
            if ((tempEntry = build.getEntry("bin.excludes")) != null && tempEntry.contains(oldName)) {
                tempEntry.renameToken(oldName, newName);
            }
            entry.setName((String)newValue);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void enableSection(boolean enable) {
        this.fEnabled = enable;
        this.fLibraryPart.setButtonEnabled(0, enable);
        this.updateDirectionalButtons();
        this.fFolderPart.setButtonEnabled(0, enable && !this.fLibraryViewer.getStructuredSelection().isEmpty());
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.fEnabled && this.fLibraryViewer.getControl().isFocusControl()) {
                this.handleDelete();
            } else if (this.fEnabled) {
                this.handleDeleteFolder();
            }
            return true;
        }
        return false;
    }

    private void doRename() {
        IStructuredSelection selection = this.fLibraryViewer.getStructuredSelection();
        if (selection.size() == 1) {
            IBuildEntry entry = (IBuildEntry)selection.getFirstElement();
            String oldName = entry.getName().substring(7);
            RenameDialog dialog = new RenameDialog(this.fLibraryViewer.getControl().getShell(), true, this.getLibraryNames(), oldName);
            dialog.setInputValidator(newText -> {
                if (newText.indexOf(32) != -1) {
                    return PDEUIMessages.AddLibraryDialog_nospaces;
                }
                return null;
            });
            dialog.create();
            dialog.setTitle(PDEUIMessages.RuntimeInfoSection_rename);
            dialog.getShell().setSize(300, 150);
            if (dialog.open() == 0) {
                this.entryModified(entry, dialog.getNewName());
            }
        }
    }

    private void refreshOutputKeys() {
        if (!this.isJavaProject()) {
            return;
        }
        IBuildEntry buildEntry = this.getLibrarySelection();
        if (buildEntry == null) {
            return;
        }
        HashSet<String> outputFolders = new HashSet<String>();
        String[] jarFolders = buildEntry.getTokens();
        IPackageFragmentRoot[] sourceFolders = this.computeSourceFolders();
        String[] stringArray = jarFolders;
        int n = jarFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            IPackageFragmentRoot sourceFolder = this.getSourceFolder(folder, sourceFolders);
            if (sourceFolder != null) {
                try {
                    IClasspathEntry entry = sourceFolder.getRawClasspathEntry();
                    IPath outputPath = entry.getOutputLocation();
                    if (outputPath == null) {
                        outputFolders.add("bin");
                    } else {
                        outputPath = outputPath.removeFirstSegments(1);
                        outputFolders.add(outputPath.toString());
                    }
                }
                catch (JavaModelException e) {
                    PDEPlugin.logException(e);
                }
            }
            ++n2;
        }
        if (!outputFolders.isEmpty()) {
            String outputName;
            String libName = buildEntry.getName().substring(7);
            IBuildModel buildModel = this.getBuildModel();
            IBuild build = buildModel.getBuild();
            IBuildEntry outputEntry = build.getEntry(outputName = "output." + libName);
            if (outputEntry == null) {
                outputEntry = buildModel.getFactory().createEntry(outputName);
                try {
                    build.add(outputEntry);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
            this.setOutputEntryTokens(outputFolders, outputEntry);
        }
    }

    private boolean isJavaProject() {
        IBuildModel buildModel = this.getBuildModel();
        IProject project = buildModel.getUnderlyingResource().getProject();
        return PluginProject.isJavaProject((IProject)project);
    }

    private boolean isReadOnly() {
        IBuildModel model = this.getBuildModel();
        if (model instanceof IEditable) {
            return !((IEditable)model).isEditable();
        }
        return true;
    }

    private void update(IBuildEntry variable) {
        int index = 0;
        if (this.fFolderViewer.getInput() == variable) {
            index = this.fFolderViewer.getTable().getSelectionIndex();
        }
        this.fFolderViewer.setInput((Object)variable);
        int count = this.fFolderViewer.getTable().getItemCount();
        if (index != -1 && count > 0) {
            if (index == count) {
                --index;
            }
            this.fFolderViewer.getTable().select(index);
        }
        this.fFolderPart.setButtonEnabled(0, !this.isReadOnly() && this.fEnabled && variable != null);
    }

    protected void updateDirectionalButtons() {
        Table table = this.fLibraryViewer.getTable();
        boolean hasSelection = table.getSelection().length > 0;
        this.fLibraryPart.setButtonEnabled(2, this.fEnabled && hasSelection && table.getSelectionIndex() > 0);
        this.fLibraryPart.setButtonEnabled(3, this.fEnabled && hasSelection && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected String[] getLibraryNames() {
        String[] libNames = new String[this.fLibraryViewer.getTable().getItemCount()];
        int i = 0;
        while (i < libNames.length) {
            libNames[i] = this.fLibraryViewer.getTable().getItem(i).getText();
            ++i;
        }
        return libNames;
    }

    protected void handleNew() {
        IPluginModelBase i;
        String[] libNames = this.getLibraryNames();
        IBaseModel pmodel = this.getPage().getModel();
        IPluginModelBase pluginModelBase = pmodel instanceof IPluginModelBase ? (i = (IPluginModelBase)pmodel) : null;
        BusyIndicator.showWhile((Display)this.fLibraryViewer.getTable().getDisplay(), () -> {
            IBuildModel buildModel = this.getBuildModel();
            IBuild build = buildModel.getBuild();
            AddLibraryDialog dialog = new AddLibraryDialog(this.getSection().getShell(), libNames, pluginModelBase);
            dialog.create();
            dialog.getShell().setText(PDEUIMessages.RuntimeInfoSection_addEntry);
            try {
                if (dialog.open() == 0) {
                    Object keyName;
                    Object name = dialog.getNewName();
                    if (!(((String)name).endsWith(".jar") || ((String)name).equals(".") || ((String)name).endsWith("/"))) {
                        name = (String)name + "/";
                    }
                    if (!((String)(keyName = name)).startsWith("source.")) {
                        keyName = "source." + (String)name;
                    }
                    if (((String)name).startsWith("source.")) {
                        name = ((String)name).substring(7);
                    }
                    if (!((String)name).endsWith(".")) {
                        this.handleLibInBinBuild(true, (String)name);
                    }
                    IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
                    int numLib = this.fLibraryViewer.getTable().getItemCount();
                    if (jarOrderEntry == null) {
                        jarOrderEntry = this.getBuildModel().getFactory().createEntry("jars.compile.order");
                        int i1 = 0;
                        while (i1 < numLib) {
                            String lib1 = ((IBuildEntry)this.fLibraryViewer.getElementAt(i1)).getName().substring(7);
                            jarOrderEntry.addToken(lib1);
                            ++i1;
                        }
                        jarOrderEntry.addToken((String)name);
                        build.add(jarOrderEntry);
                    } else if (jarOrderEntry.getTokens().length < numLib) {
                        String[] tokens;
                        String[] stringArray2 = tokens = jarOrderEntry.getTokens();
                        int n = tokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String token = stringArray2[n2];
                            jarOrderEntry.removeToken(token);
                            ++n2;
                        }
                        int i2 = 0;
                        while (i2 < numLib) {
                            String lib2 = ((IBuildEntry)this.fLibraryViewer.getElementAt(i2)).getName().substring(7);
                            jarOrderEntry.addToken(lib2);
                            ++i2;
                        }
                        jarOrderEntry.addToken((String)name);
                    } else {
                        jarOrderEntry.addToken((String)name);
                    }
                    IBuildEntry library = buildModel.getFactory().createEntry((String)keyName);
                    build.add(library);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        });
    }

    private IPackageFragmentRoot getSourceFolder(String folderName, IPackageFragmentRoot[] sourceFolders) {
        IPackageFragmentRoot[] iPackageFragmentRootArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot sourceFolder = iPackageFragmentRootArray[n2];
            if (sourceFolder.getPath().removeFirstSegments(1).equals((Object)IPath.fromOSString((String)folderName))) {
                return sourceFolder;
            }
            ++n2;
        }
        return null;
    }

    protected void handleDelete() {
        int index = this.fLibraryViewer.getTable().getSelectionIndex();
        if (index != -1) {
            String libName = this.fLibraryViewer.getTable().getItem(index).getText();
            IBuild build = this.getBuildModel().getBuild();
            try {
                String entryName;
                IBuildEntry entry = build.getEntry("jars.compile.order");
                int numLib = this.fLibraryViewer.getTable().getItemCount();
                if (entry == null) {
                    entry = this.getBuildModel().getFactory().createEntry("jars.compile.order");
                    int i = 0;
                    while (i < numLib) {
                        String lib = ((IBuildEntry)this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                        entry.addToken(lib);
                        ++i;
                    }
                    build.add(entry);
                } else if (entry.getTokens().length < numLib) {
                    String[] tokens;
                    String[] stringArray = tokens = entry.getTokens();
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        entry.removeToken(token);
                        ++n2;
                    }
                    int i = 0;
                    while (i < numLib) {
                        Object element = this.fLibraryViewer.getElementAt(i);
                        if (element != null) {
                            String lib = ((IBuildEntry)element).getName().substring(7);
                            entry.addToken(lib);
                        }
                        ++i;
                    }
                }
                entry.removeToken(libName);
                entry = build.getEntry("output." + libName);
                if (entry != null) {
                    build.remove(entry);
                }
                if ((entry = build.getEntry("bin.includes")) != null && entry.contains(libName)) {
                    entry.removeToken(libName);
                }
                if ((entry = build.getEntry("bin.excludes")) != null && entry.contains(libName)) {
                    entry.removeToken(libName);
                }
                if ((entry = build.getEntry(entryName = "source." + libName)) != null) {
                    build.remove(entry);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleDeleteFolder() {
        Object object = this.fFolderViewer.getStructuredSelection().getFirstElement();
        if (object == null) {
            return;
        }
        IBuildEntry entry = this.getLibrarySelection();
        if (entry == null) {
            return;
        }
        try {
            entry.removeToken((String)object);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IFolder openSelectFolderDialog(IBuildEntry entry, String title, String message) {
        IFile file = (IFile)this.getBuildModel().getUnderlyingResource();
        final IProject project = file.getProject();
        FolderSelectionDialog dialog = new FolderSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new JarsNewContentProvider(this){});
        dialog.setInput(project.getWorkspace());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return element instanceof IFolder;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setValidator(selection -> {
            if (selection == null || selection.length != 1 || !(selection[0] instanceof IFolder)) {
                return Status.error((String)"");
            }
            String folderPath = ((IFolder)selection[0]).getProjectRelativePath().addTrailingSeparator().toString();
            if (entry != null && entry.contains(folderPath)) {
                return Status.error((String)PDEUIMessages.BuildEditor_RuntimeInfoSection_duplicateFolder);
            }
            return Status.OK_STATUS;
        });
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private void handleNewFolder() {
        IBuildEntry entry = this.getLibrarySelection();
        IFolder folder = this.openSelectFolderDialog(entry, PDEUIMessages.ManifestEditor_JarsSection_dialogTitle, PDEUIMessages.ManifestEditor_JarsSection_dialogMessage);
        if (folder != null) {
            try {
                String folderPath = folder.getProjectRelativePath().addTrailingSeparator().toString();
                entry.addToken(folderPath);
                this.refreshOutputKeys();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleRenameFolder(String oldName) {
        IBuildEntry entry = this.getLibrarySelection();
        IFolder folder = this.openSelectFolderDialog(entry, PDEUIMessages.RuntimeInfoSection_replacedialog, PDEUIMessages.ManifestEditor_JarsSection_dialogMessage);
        if (folder != null) {
            try {
                String newFolder = folder.getProjectRelativePath().addTrailingSeparator().toString();
                entry.renameToken(oldName, newFolder);
                this.refreshOutputKeys();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    protected void updateJarsCompileOrder(boolean up) {
        int direction = up ? -1 : 1;
        int index = this.fLibraryViewer.getTable().getSelectionIndex();
        String library1 = ((IBuildEntry)this.fLibraryViewer.getElementAt(index)).getName().substring(7);
        String library2 = ((IBuildEntry)this.fLibraryViewer.getElementAt(index + direction)).getName().substring(7);
        IBuildModel model = this.getBuildModel();
        IBuild build = model.getBuild();
        IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
        try {
            if (jarOrderEntry == null) {
                jarOrderEntry = model.getFactory().createEntry("jars.compile.order");
                build.add(jarOrderEntry);
            } else {
                String[] tokens;
                String[] stringArray = tokens = jarOrderEntry.getTokens();
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    jarOrderEntry.removeToken(token);
                    ++n2;
                }
            }
            int numLib = this.fLibraryViewer.getTable().getItemCount();
            String[] names = new String[numLib];
            int i = 0;
            while (i < numLib) {
                String name = ((IBuildEntry)this.fLibraryViewer.getElementAt(i)).getName().substring(7);
                if (name.equals(library1)) {
                    name = library2;
                } else if (name.equals(library2)) {
                    name = library1;
                }
                names[i] = name;
                ++i;
            }
            i = 0;
            while (i < numLib) {
                jarOrderEntry.addToken(names[i]);
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void modelChanged(IModelChangedEvent event) {
        void entry;
        if (event.getChangeType() == 99) {
            this.markStale();
        }
        Object changeObject = event.getChangedObjects()[0];
        String keyName = event.getChangedProperty();
        if (!(changeObject instanceof IBuildEntry)) {
            return;
        }
        IBuildEntry iBuildEntry = (IBuildEntry)changeObject;
        String entryName = entry.getName();
        if (!(entryName.startsWith("source.") || entryName.equals("jars.compile.order") || entryName.equals("bin.includes"))) {
            return;
        }
        if (entryName.equals("bin.includes")) {
            return;
        }
        int type = event.getChangeType();
        if (entry.getName().startsWith("source.")) {
            StructuredSelection newSel = null;
            if (type == 1) {
                this.fLibraryViewer.add((Object)entry);
                newSel = new StructuredSelection((Object)entry);
            } else if (type == 2) {
                int index = this.fLibraryViewer.getTable().getSelectionIndex();
                this.fLibraryViewer.remove((Object)entry);
                Table table = this.fLibraryViewer.getTable();
                int itemCount = table.getItemCount();
                if (itemCount != 0) {
                    index = index < itemCount ? index : itemCount - 1;
                    newSel = new StructuredSelection(table.getItem(index).getData());
                }
            } else if (keyName != null && keyName.startsWith("source.")) {
                if (event.getOldValue() != null && event.getNewValue() != null) {
                    this.fLibraryViewer.update((Object)entry, null);
                }
                newSel = new StructuredSelection((Object)entry);
            }
            this.fLibraryViewer.setSelection((ISelection)newSel);
        } else if (keyName != null && keyName.equals("jars.compile.order")) {
            if (event.getNewValue() == null && event.getOldValue() != null) {
                return;
            }
            if (event.getOldValue() != null && event.getNewValue() != null) {
                return;
            }
            this.fLibraryViewer.refresh();
            this.updateDirectionalButtons();
        }
    }

    private IBuildEntry getLibrarySelection() {
        IStructuredSelection selection = this.fLibraryViewer.getStructuredSelection();
        return (IBuildEntry)selection.getFirstElement();
    }

    public static class FolderContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            Object[] objectArray;
            if (parent instanceof IBuildEntry) {
                IBuildEntry i = (IBuildEntry)parent;
                objectArray = i.getTokens();
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }
    }

    public static class FolderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            return sharedImages.getImage("IMG_OBJ_FOLDER");
        }
    }

    class JarsNewContentProvider
    extends WorkbenchContentProvider {
        JarsNewContentProvider() {
        }

        public boolean hasChildren(Object element) {
            Object[] children;
            Object[] objectArray = children = this.getChildren(element);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof IFolder) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class LibraryContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildModel) {
                String[] tokens;
                IBuild build = ((IBuildModel)parent).getBuild();
                IBuildEntry jarOrderEntry = build.getEntry("jars.compile.order");
                Object[] libraries = BuildUtil.getBuildLibraries(build.getBuildEntries());
                if (jarOrderEntry == null) {
                    return libraries;
                }
                ArrayList<Object> libList = new ArrayList<Object>();
                String[] stringArray = tokens = jarOrderEntry.getTokens();
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    IBuildEntry entry = build.getEntry("source." + token);
                    if (entry != null) {
                        libList.add(entry);
                    }
                    ++n2;
                }
                int i = 0;
                while (i < libraries.length) {
                    if (!libList.contains(libraries[i])) {
                        libList.add(libraries[i]);
                    }
                    ++i;
                }
                return libList.toArray();
            }
            return new Object[0];
        }
    }

    public static class LibraryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            String name = ((IBuildEntry)obj).getName();
            if (name.startsWith("source.")) {
                return name.substring("source.".length());
            }
            return name;
        }

        public Image getColumnImage(Object obj, int index) {
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            return provider.get(PDEPluginImages.DESC_JAVA_LIB_OBJ);
        }
    }

    class PartAdapter
    extends TablePart {
        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        @Override
        public void selectionChanged(IStructuredSelection selection) {
            RuntimeInfoSection.this.getPage().getPDEEditor().setSelection((ISelection)selection);
            Object item = selection.getFirstElement();
            if (item instanceof IBuildEntry) {
                RuntimeInfoSection.this.update((IBuildEntry)item);
            } else if (selection.isEmpty()) {
                RuntimeInfoSection.this.update(null);
            }
            RuntimeInfoSection.this.updateDirectionalButtons();
        }

        @Override
        public void handleDoubleClick(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (RuntimeInfoSection.this.getLibrarySelection() == element) {
                RuntimeInfoSection.this.doRename();
            } else if (element instanceof String) {
                RuntimeInfoSection.this.handleRenameFolder((String)element);
            }
        }

        @Override
        public void buttonSelected(Button button, int index) {
            if (this.getViewer() == RuntimeInfoSection.this.fLibraryPart.getViewer()) {
                switch (index) {
                    case 0: {
                        RuntimeInfoSection.this.handleNew();
                        break;
                    }
                    case 2: {
                        RuntimeInfoSection.this.updateJarsCompileOrder(true);
                        break;
                    }
                    case 3: {
                        RuntimeInfoSection.this.updateJarsCompileOrder(false);
                    }
                }
            } else if (this.getViewer() == RuntimeInfoSection.this.fFolderPart.getViewer() && index == 0) {
                RuntimeInfoSection.this.handleNewFolder();
            } else {
                button.getShell().setDefaultButton(null);
            }
        }
    }
}

