/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.emf;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.core.emf.Messages;
import org.eclipse.m2m.atl.core.service.LauncherService;

public class EMFExtractor
implements IExtractor {
    public void extract(IModel sourceModel, String target, Map<String, Object> options) throws ATLCoreException {
        if (target != null) {
            EMFExtractor.recreateResourceIfNeeded((EMFModel)sourceModel, URI.createURI((String)target), (String)options.get("contentType"), LauncherService.getBooleanOption((Object)options.get("OPTION_CONTENT_TYPE"), (boolean)false));
            HashMap<String, Object> extractOptions = new HashMap<String, Object>();
            extractOptions.put("ENCODING", "ISO-8859-1");
            extractOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
            if (options != null) {
                extractOptions.putAll(options);
            }
            try {
                ((EMFModel)sourceModel).getResource().save(extractOptions);
            }
            catch (IOException e) {
                throw new ATLCoreException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new ATLCoreException(Messages.getString("EMFExtractor.NO_PATH"));
        }
    }

    public void extract(IModel sourceModel, String target) throws ATLCoreException {
        this.extract(sourceModel, target, Collections.emptyMap());
    }

    public void extract(EMFModel sourceModel, OutputStream target, String fileExtension, Map<String, Object> options) throws ATLCoreException {
        EMFExtractor.recreateResourceIfNeeded(sourceModel, URI.createURI((String)("tmp." + fileExtension)), (String)options.get("contentType"), (Boolean)options.get("contentTypeLookup"));
        this.extract((IModel)sourceModel, target, options);
    }

    public void extract(IModel sourceModel, OutputStream target, Map<String, Object> options) throws ATLCoreException {
        if (((EMFModel)sourceModel).getResource() == null) {
            ((EMFModel)sourceModel).setResource(((EMFModel)sourceModel).getModelFactory().getResourceSet().createResource(URI.createURI((String)"tmp")));
            return;
        }
        HashMap<String, Object> extractOptions = new HashMap<String, Object>();
        extractOptions.put("ENCODING", "ISO-8859-1");
        extractOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        if (options != null) {
            extractOptions.putAll(options);
        }
        try {
            ((EMFModel)sourceModel).getResource().save(target, extractOptions);
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected static void recreateResourceIfNeeded(EMFModel model, URI uri, String contentType, boolean contentTypeLookup) throws ATLCoreException {
        EMFReferenceModel referenceModel;
        Resource mmResource;
        ResourceSet resourceSet = model.getModelFactory().getResourceSet();
        if (contentType == null && contentTypeLookup && (mmResource = (referenceModel = model.getReferenceModel()).getResource()) != null) {
            contentType = EMFExtractor.getContentTypeIdentifier(resourceSet, mmResource.getURI());
        }
        if (model.getResource() == null) {
            model.setResource(EMFExtractor.createResource(resourceSet, uri, contentType));
            return;
        }
        if (contentType != null || !uri.toString().endsWith(".xmi")) {
            Resource newResource = EMFExtractor.createResource(resourceSet, uri, contentType);
            newResource.getContents().addAll((Collection)model.getResource().getContents());
            model.setResource(newResource);
        } else {
            model.getResource().setURI(uri);
        }
    }

    private static Resource createResource(ResourceSet resourceSet, URI uri, String contentType) throws ATLCoreException {
        if (contentType != null) {
            try {
                Method method = resourceSet.getClass().getDeclaredMethod("createResource", URI.class, String.class);
                try {
                    if (method != null) {
                        return (Resource)method.invoke((Object)resourceSet, uri, contentType);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ATLCoreException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ATLCoreException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ATLCoreException(e.getMessage(), (Throwable)e);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return resourceSet.createResource(uri);
    }

    private static String getContentTypeIdentifier(ResourceSet resourceSet, URI uri) {
        EPackage pack = resourceSet.getPackageRegistry().getEPackage(uri.toString());
        if (pack != null) {
            try {
                Field contentType = pack.getClass().getField("eCONTENT_TYPE");
                if (contentType != null) {
                    return (String)contentType.get(pack);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }
}

