/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.internal.docker.core.ProcessLauncher;
import org.eclipse.linuxtools.internal.docker.core.SystemUtils;

public class DockerMachine {
    private static DockerMachine instance = new DockerMachine();
    private ProcessLauncher processLauncher = new ProcessLauncher();

    public static DockerMachine getInstance() {
        return instance;
    }

    private DockerMachine() {
    }

    public void setProcessLauncher(ProcessLauncher processLauncher) {
        this.processLauncher = processLauncher;
    }

    public boolean checkPathToDockerMachine(String dockerMachineInstallDir) {
        return this.processLauncher.checkPathToCommand(dockerMachineInstallDir, DockerMachine.getDockerMachineExecutableName());
    }

    public String[] getNames(String pathToDockerMachine) throws DockerException {
        return this.processLauncher.processBuilder(pathToDockerMachine, DockerMachine.getDockerMachineExecutableName(), new String[]{"ls", "-q"}).startAndGetResult();
    }

    public String getHost(String name, String dockerMachineInstallDir, String vmDriverInstallDir) throws DockerException {
        String[] res = this.processLauncher.processBuilder(dockerMachineInstallDir, DockerMachine.getDockerMachineExecutableName(), new String[]{"url", name}).extraPath(vmDriverInstallDir).startAndGetResult();
        return res.length == 1 ? res[0] : null;
    }

    public String getCertPath(String name, String pathToDockerMachine, String vmDriverInstallDir) throws DockerException {
        String[] envVariables;
        ProcessLauncher.FluentProcessBuilder processBuilder = this.processLauncher.processBuilder(pathToDockerMachine, DockerMachine.getDockerMachineExecutableName(), new String[]{"env", name}).extraPath(vmDriverInstallDir);
        for (String envVariable : envVariables = processBuilder.startAndGetResult()) {
            if (!envVariable.contains("DOCKER_CERT_PATH")) continue;
            return envVariable.split("=")[1].replace("\"", "");
        }
        return null;
    }

    private static String getDockerMachineExecutableName() {
        if (SystemUtils.isWindows()) {
            return "docker-machine.exe";
        }
        return "docker-machine";
    }
}

