/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IProjectSelector;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.NonStreamResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.WorkspaceCUFinder;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.SerializerAdapterFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.InitialModelSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.OnEventModelSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.facets.FacetUtils;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;

public class JaxWsWorkspaceResource
extends NonStreamResource {
    private final IJavaModel javaModel;
    private final ServiceModelData serviceData;
    private final OnEventModelSynchronizer modelSynchronizer;
    private final SerializerAdapterFactory serializerFactory;
    private IProgressMonitor monitor;
    private boolean saveEnabled;
    private boolean loadCnaceled;

    public JaxWsWorkspaceResource(IJavaModel javaModel) {
        this.javaModel = javaModel;
        this.serviceData = new ServiceModelData();
        this.modelSynchronizer = new OnEventModelSynchronizer(this, this.serviceData);
        this.saveEnabled = true;
        this.serializerFactory = new SerializerAdapterFactory(this);
    }

    public void setProgressMonitor(IProgressMonitor pm) {
        this.monitor = pm;
    }

    public IDOM getDOM() {
        if (this.getContents().size() == 0) {
            return null;
        }
        return (IDOM)this.getContents().get(0);
    }

    public void startSynchronizing() {
        JavaCore.addElementChangedListener((IElementChangedListener)this.modelSynchronizer, (int)5);
    }

    public void stopSynchronizing() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.modelSynchronizer);
    }

    public ILogger logger() {
        return new Logger();
    }

    public IJavaModel javaModel() {
        return this.javaModel;
    }

    @Override
    protected void doLoad(final Map<?, ?> options) throws IOException {
        this.loadCnaceled = false;
        this.getContents().clear();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor subMonitor) throws CoreException {
                try {
                    new InitialModelSynchronizer(JaxWsWorkspaceResource.this, JaxWsWorkspaceResource.this.serviceData).load(options, subMonitor);
                }
                catch (WsDOMLoadCanceledException e) {
                    JaxWsWorkspaceResource.this.loadCnaceled = true;
                    JaxWsWorkspaceResource.this.logger().logError("JAX WS Web Services DOM loading has been canceled by the user, some JAX WS Web Services functionalities won't be available", (Throwable)e);
                }
            }
        };
        try {
            this.javaModel().getWorkspace().run(runnable, this.monitor);
        }
        catch (CoreException ce) {
            throw new Resource.IOWrappedException((Exception)((Object)ce));
        }
    }

    @Override
    protected void doSave(Map<?, ?> options) throws IOException {
    }

    protected IElementChangedListener getSynchronizingListener() {
        return this.modelSynchronizer;
    }

    public ICompilationUnitFinder newCompilationUnitFinder(IJavaModel jModel, IProjectSelector[] projectSelectors) {
        return new WorkspaceCUFinder(jModel, projectSelectors);
    }

    public boolean approveProject(IJavaProject prj) {
        FacetUtils facetUtils = new FacetUtils();
        try {
            return facetUtils.hasFacetWithVersion(prj.getProject(), "3.0", "jst.ejb", true) || facetUtils.hasFacetWithVersion(prj.getProject(), "2.5", "jst.web", true);
        }
        catch (CoreException ce) {
            this.logger().logError("Unable to read facet on project " + prj.getElementName() + ". Any Web Service elements in this project will not be shown in the navigation tree", (Throwable)ce);
            return false;
        }
    }

    public IAnnotationInspector newAnnotationInspector(IType type) {
        return AnnotationFactory.createAnnotationInspector((IType)type);
    }

    public IProjectSelector[] getProjectSelectors() {
        return new IProjectSelector[]{new IProjectSelector(){

            @Override
            public boolean approve(IJavaProject prj) {
                return JaxWsWorkspaceResource.this.approveProject(prj);
            }
        }};
    }

    public SerializerAdapterFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    public synchronized void enableSaving() {
        this.saveEnabled = true;
    }

    public synchronized void disableSaving() {
        this.saveEnabled = false;
    }

    public boolean isLoadCnaceled() {
        return this.loadCnaceled;
    }

    public class ServiceModelData {
        private Map<IWebService, String> ws2sei = new HashMap<IWebService, String>();
        private Map<String, Collection<IWebService>> sei2ws = new HashMap<String, Collection<IWebService>>();
        private Map<String, Collection<ICompilationUnit>> type2inherited = new HashMap<String, Collection<ICompilationUnit>>();

        public void map(IWebService ws, String seiImpl) {
            this.ws2sei.put(ws, seiImpl);
            this.getImplementingWs(seiImpl).add(ws);
        }

        String getSeiImpl(IWebService ws) {
            return this.ws2sei.get(ws);
        }

        public Collection<IWebService> getImplementingWs(String seiIml) {
            Collection<IWebService> wss = this.sei2ws.get(seiIml);
            if (wss == null) {
                wss = new ArrayList<IWebService>();
                this.sei2ws.put(seiIml, wss);
            }
            return wss;
        }

        public void unmap(IWebService ws) {
            String sei = this.ws2sei.remove(ws);
            Collection<IWebService> implementingWebServices = this.getImplementingWs(sei);
            implementingWebServices.remove(ws);
            if (implementingWebServices.size() == 0) {
                this.sei2ws.remove(sei);
            }
        }

        public void recordHierarchy(String fqName, Collection<ICompilationUnit> inheritedTypes) {
            this.type2inherited.put(fqName, inheritedTypes);
        }

        public Collection<ICompilationUnit> getHierarchy(String fqName) {
            return this.type2inherited.get(fqName);
        }

        public void clearHierarchy(String fqName) {
            this.type2inherited.remove(fqName);
        }
    }
}

