/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import org.eclipse.jst.pagedesigner.properties.celleditors.AbstractCSSModelAdapter;
import org.eclipse.wst.css.core.internal.parser.CSSSourceParser;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleDeclarationAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class TagStyleAttrAdapter
extends AbstractCSSModelAdapter
implements IStructuredDocumentListener,
IStyleDeclarationAdapter {
    private boolean ignoreNotification = false;
    private String _styleAttrName;

    TagStyleAttrAdapter(String attrName) {
        this._styleAttrName = attrName;
    }

    public ICSSModel getModel() {
        ICSSModel model = this.getExistingModel();
        if (model == null && this.isModelNecessary()) {
            model = this.createModel();
            if (model == null) {
                return null;
            }
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            if (structuredDocument == null) {
                return null;
            }
            RegionParser parser = structuredDocument.getParser();
            if (!(parser instanceof CSSSourceParser)) {
                return null;
            }
            ((CSSSourceParser)parser).setParserMode(1);
            structuredDocument.addDocumentChangedListener((IStructuredDocumentListener)this);
            this.setModel(model);
            this.valueChanged();
        }
        if (model != null && !this.isModelNecessary()) {
            model = null;
            this.valueChanged();
        }
        return model;
    }

    public CSSStyleDeclaration getStyle() {
        ICSSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        return (CSSStyleDeclaration)model.getDocument();
    }

    public boolean isAdapterForType(Object type) {
        return type == IStyleDeclarationAdapter.class;
    }

    public void newModel(NewDocumentEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this) {
            return;
        }
        this.setValue();
    }

    public void noChange(NoChangeEvent structuredDocumentEvent) {
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this) {
            return;
        }
        this.setValue();
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.ignoreNotification) {
            return;
        }
        if (eventType != 1) {
            return;
        }
        Attr attr = (Attr)changedFeature;
        if (attr == null) {
            return;
        }
        String name = attr.getName();
        if (name.equalsIgnoreCase(this._styleAttrName)) {
            this.valueChanged();
        }
    }

    public void regionChanged(RegionChangedEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this) {
            return;
        }
        this.setValue();
    }

    public void regionsReplaced(RegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        if (event.getOriginalRequester() == this) {
            return;
        }
        this.setValue();
    }

    private void setValue() {
        int count;
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        ICSSModel model = this.getExistingModel();
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        String value = null;
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        if (flatNodes != null && (count = flatNodes.getLength()) > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion flatNode = flatNodes.item(i);
                if (flatNode != null) {
                    buffer.append(flatNode.getText());
                }
                ++i;
            }
            value = buffer.toString();
        }
        this.ignoreNotification = true;
        if (value == null || value.length() == 0) {
            element.removeAttribute(this._styleAttrName);
        } else {
            Attr attr = element.getAttributeNode(this._styleAttrName);
            if (attr != null) {
                ((IDOMNode)attr).setValueSource(value);
            } else {
                Document document = element.getOwnerDocument();
                attr = document.createAttribute(this._styleAttrName);
                ((IDOMNode)attr).setValueSource(value);
                element.setAttributeNode(attr);
            }
        }
        this.ignoreNotification = false;
        this.notifyStyleChanged(element);
    }

    private void valueChanged() {
        Element element = this.getElement();
        if (element == null) {
            return;
        }
        if (!this.isModelNecessary()) {
            this.setModel(null);
            this.notifyStyleChanged(element);
            return;
        }
        ICSSModel model = this.getExistingModel();
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        String value = null;
        Attr attr = element.getAttributeNode(this._styleAttrName);
        if (attr != null) {
            value = ((IDOMNode)attr).getValueSource();
        }
        structuredDocument.setText((Object)this, value);
        this.notifyStyleChanged(element);
    }

    private boolean isModelNecessary() {
        return this.getElement() != null;
    }
}

