/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.ui.internal.validation.Messages;
import org.eclipse.jst.jsf.ui.internal.validation.MyLocalizedMessage;
import org.eclipse.jst.jsf.ui.internal.validation.SeverityOverrideStrategy;
import org.eclipse.jst.jsf.validation.internal.ELValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.JSFTypeComparatorPreferences;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.facelet.FaceletValidationPreferences;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.core.Message;

public final class ValidationMessageFactory {
    private final Map<String, SeverityOverrideStrategy> _strategies;
    private IStructuredModel _model = null;

    public ValidationMessageFactory(ValidationPreferences prefs, IStructuredModel model) {
        this._model = model;
        this._strategies = new HashMap<String, SeverityOverrideStrategy>();
        this._strategies.put("org.eclipse.jst.jsf.validation.el.Diagnostics", new ELSeverityOverrideStrategy(prefs));
        this._strategies.put("org.eclipse.jst.jsf.common.types.TypeComparator", new TypeComparatorOverrideStrategy(prefs));
        this._strategies.put("org.eclipse.jst.jsf.facelet.core.internal.validation.diagnostics.Diagnostics", new FaceletSeverityOverrideStrategy(prefs));
    }

    public Message createFromDiagnostic(Diagnostic diagnostic, int offset, int length, IFile file) {
        int line;
        IStructuredDocument flatModel;
        Integer value;
        int severity = diagnostic.getSeverity();
        String sourceId = diagnostic.getSource();
        SeverityOverrideStrategy strategy = this._strategies.get(sourceId);
        if (strategy != null && (value = strategy.override(diagnostic)) != null) {
            severity = value;
        }
        MyLocalizedMessage message = new MyLocalizedMessage(this.convertSeverity(severity), diagnostic.getMessage(), (IResource)file, diagnostic.getCode());
        message.setOffset(offset);
        message.setLength(length);
        if (this._model != null && (flatModel = this._model.getStructuredDocument()) != null && (line = flatModel.getLineOfOffset(message.getOffset())) >= 0) {
            message.setLineNo(line + 1);
        }
        return message;
    }

    private int convertSeverity(int severity) {
        switch (severity) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 0;
    }

    private static class ELSeverityOverrideStrategy
    extends SeverityOverrideStrategy {
        private final ValidationPreferences _prefs;

        public ELSeverityOverrideStrategy(ValidationPreferences prefs) {
            super("org.eclipse.jst.jsf.validation.el.Diagnostics");
            this._prefs = prefs;
        }

        @Override
        public Integer override(Diagnostic diagnostic) {
            int code = diagnostic.getCode();
            ELValidationPreferences elPrefs = this._prefs.getElPrefs();
            return elPrefs.getDiagnosticSeverity(code);
        }

        @Override
        public String getDisplayName() {
            return Messages.ValidationMessageFactory_DefaultElSeverityDisplayName;
        }
    }

    private static class FaceletSeverityOverrideStrategy
    extends SeverityOverrideStrategy {
        private final ValidationPreferences _prefs;

        public FaceletSeverityOverrideStrategy(ValidationPreferences prefs) {
            super("org.eclipse.jst.jsf.facelet.core.internal.validation.diagnostics.Diagnostics");
            this._prefs = prefs;
        }

        @Override
        public Integer override(Diagnostic diagnostic) {
            int code = diagnostic.getCode();
            FaceletValidationPreferences faceletPrefs = this._prefs.getFaceletValidationPrefs();
            return faceletPrefs.getDiagnosticSeverity(code);
        }

        @Override
        public String getDisplayName() {
            return Messages.ValidationMessageFactory_DefaultFaceletSeverityDisplayName;
        }
    }

    private static class TypeComparatorOverrideStrategy
    extends SeverityOverrideStrategy {
        private final ValidationPreferences _prefs;

        public TypeComparatorOverrideStrategy(ValidationPreferences prefs) {
            super("org.eclipse.jst.jsf.common.types.TypeComparator");
            this._prefs = prefs;
        }

        @Override
        public Integer override(Diagnostic diagnostic) {
            int code = diagnostic.getCode();
            JSFTypeComparatorPreferences jsfTypeCompPrefs = this._prefs.getTypeComparatorPrefs();
            return jsfTypeCompPrefs.getDiagnosticSeverity(code);
        }

        @Override
        public String getDisplayName() {
            return Messages.ValidationMessageFactory_DefaultTypeComparatorDisplayName;
        }
    }
}

