/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.validation;

import java.util.ArrayList;
import org.eclipse.jst.jsf.core.internal.CompositeJSFPreferenceModel;
import org.eclipse.jst.jsf.core.internal.IJSFPreferenceModel;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.validation.ProblemSeveritiesConfigurationBlock;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

class ELPrefPanel {
    private final Group _container;
    private final Button _chkBuildValidation;
    private final Button _chkIncrementalValidation;
    private final ProblemSeveritiesConfigurationBlock _problemSeverities;
    private final ValidationPreferences _prefs;

    public ELPrefPanel(Composite parent, IWorkbenchPreferenceContainer container, ValidationPreferences prefs) {
        this._prefs = prefs;
        this._container = new Group(parent, 0);
        this._container.setText(Messages.JSFValidationPreferencePage_ELPrefPanel_Title);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginTop = 5;
        rowLayout.marginLeft = 5;
        this._container.setLayout((Layout)rowLayout);
        this._chkBuildValidation = new Button((Composite)this._container, 32);
        this._chkBuildValidation.setText(Messages.JSFValidationPreferencePage_ELPrefPanel_BuildValidationCheckBoxTitle);
        this._chkBuildValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELPrefPanel.this._prefs.getElPrefs().setEnableBuildValidation(ELPrefPanel.this._chkBuildValidation.getSelection());
                ELPrefPanel.this.refresh();
            }
        });
        this._chkIncrementalValidation = new Button((Composite)this._container, 32);
        this._chkIncrementalValidation.setText(Messages.JSFValidationPreferencePage_ELPrefPanel_IncrementalValidationCheckBoxTitle);
        this._chkIncrementalValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ELPrefPanel.this._prefs.getElPrefs().setEnableIncrementalValidation(ELPrefPanel.this._chkIncrementalValidation.getSelection());
                ELPrefPanel.this.refresh();
            }
        });
        new Label((Composite)this._container, 0);
        ArrayList<Object> models = new ArrayList<Object>();
        models.add(this._prefs.getElPrefs());
        models.add(this._prefs.getTypeComparatorPrefs());
        CompositeJSFPreferenceModel compositeModel = new CompositeJSFPreferenceModel(models);
        this._problemSeverities = new ProblemSeveritiesConfigurationBlock((IJSFPreferenceModel)compositeModel, null, container);
        this._problemSeverities.createContents((Composite)this._container);
    }

    public Control getControl() {
        return this._container;
    }

    public void refresh() {
        this._chkBuildValidation.setSelection(this._prefs.getElPrefs().isEnableBuildValidation());
        this._chkIncrementalValidation.setSelection(this._prefs.getElPrefs().isEnableIncrementalValidation());
        this._problemSeverities.updateControls();
    }

    public void processChanges() {
        this._problemSeverities.performOk();
    }
}

