/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.ABeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBType;
import org.eclipse.jst.j2ee.model.internal.validation.IFieldType;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodAndFieldConstants;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodType;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;

public final class MethodUtility {
    private static MethodUtility _inst = null;
    private long[] _methodTypeIndex;
    private IMethodType[] _methodTypes;
    private long[] _fieldTypeIndex;
    private IFieldType[] _fieldTypes;

    private MethodUtility() {
        this.buildTypeList();
    }

    public static MethodUtility getUtility() {
        if (_inst == null) {
            _inst = new MethodUtility();
        }
        return _inst;
    }

    protected IMethodType[] getMethodTypes() {
        return this._methodTypes;
    }

    public IFieldType getFieldType(long type) {
        int index = Arrays.binarySearch(this._fieldTypeIndex, type);
        if (index > this._fieldTypes.length) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (this._fieldTypes[index].getId() != type) {
            return null;
        }
        return this._fieldTypes[index];
    }

    public IMethodType getMethodType(long type) {
        int index = Arrays.binarySearch(this._methodTypeIndex, type);
        if (index > this._methodTypes.length) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (this._methodTypes[index].getId() != type) {
            return null;
        }
        return this._methodTypes[index];
    }

    public long getMethodTypeId(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists, IEJBType rule) {
        IMethodType mType = this.getMethodType(bean, clazz, method, methodsExtendedLists, rule);
        if (mType == null) {
            return rule.getDefaultMethodType();
        }
        return mType.getId();
    }

    public long getFieldTypeId(EnterpriseBean bean, JavaClass clazz, Field field, IEJBType rule) {
        IFieldType mType = this.getFieldType(bean, clazz, field, rule);
        if (mType == null) {
            return IMethodAndFieldConstants.EXCLUDED_FIELD;
        }
        return mType.getId();
    }

    public IFieldType getFieldType(EnterpriseBean bean, JavaClass clazz, Field field, IEJBType rule) {
        IFieldType[] knownFieldTypes = this._fieldTypes;
        if (knownFieldTypes == null) {
            return null;
        }
        int i = 0;
        while (i < knownFieldTypes.length) {
            IFieldType mt = knownFieldTypes[i];
            if (mt != null && mt.isFieldType(bean, clazz, field)) {
                return mt;
            }
            ++i;
        }
        return null;
    }

    public IMethodType getMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists, IEJBType rule) {
        long[] knownMethodTypes = rule.getKnownMethodTypes();
        if (knownMethodTypes == null) {
            return null;
        }
        int i = 0;
        while (i < knownMethodTypes.length) {
            IMethodType mt = this.getMethodType(knownMethodTypes[i]);
            if (mt != null && !mt.isDefaultType() && mt.isMethodType(bean, clazz, method, methodsExtendedLists)) {
                return mt;
            }
            ++i;
        }
        return this.getMethodType(rule.getDefaultMethodType());
    }

    private void buildTypeList() {
        int typeCount = 29;
        this._methodTypeIndex = new long[typeCount];
        this._methodTypes = new IMethodType[typeCount];
        int count = 0;
        int fieldTypeCount = 1;
        this._fieldTypeIndex = new long[fieldTypeCount];
        this._fieldTypes = new IFieldType[fieldTypeCount];
        int fieldCount = 0;
        this._methodTypeIndex[count] = IMethodAndFieldConstants.ACCESSOR;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.ACCESSOR;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.acc";
            }

            @Override
            public String getMessageId_messageExists() {
                return "ACCESSOR::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "ACCESSOR::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "ACCESSOR::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "ACCESSOR::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.BUSINESS;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.BUSINESS;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                if (method == null) {
                    return "";
                }
                return method.getName();
            }

            @Override
            public String getMessageId_messageMissing() {
                return "BUSINESS::getMessageId_messageMissing";
            }

            @Override
            public String getMessageId_messageExists() {
                return "BUSINESS::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.bus";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.business";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.bus";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (ValidationRuleUtility.getMethod(method, method.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(methodsExtendedLists)) != null) {
                    return true;
                }
                return ValidationRuleUtility.getMethod(method, method.getName(), ABeanClassVRule.getLocalComponentMethodsExtended(methodsExtendedLists)) != null;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CLINIT;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.CLINIT;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "clinit";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CLINIT::getMessageId_messageMissing";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CLINIT::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CLINIT::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CLINIT::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CLINIT::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("<clinit>");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CONSTRUCTOR;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.CONSTRUCTOR;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return clazz.getName();
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.constr";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CONSTRUCTOR::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CONSTRUCTOR::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CONSTRUCTOR::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CONSTRUCTOR::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.isConstructor();
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return String.valueOf(clazz.getName()) + "()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.constr";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.isConstructor() && ValidationRuleUtility.isPublic(method) && method.getParameters().size() == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CREATE;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.CREATE;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "create";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.create";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CREATE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.create";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.create";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.create";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("create");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CREATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.CREATE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "create()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.create";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CREATE_NOPARM::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.create";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.create";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.create";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("create") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBACTIVATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBACTIVATE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbActivate()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbActivate";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbActivate") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBCREATE;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBCREATE;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbCreate";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbCreate";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBCREATE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbCreate";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBCREATE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbCreate";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbCreate");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBCREATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBCREATE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbCreate()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbCreate";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBCREATE_NOPARM::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbCreate";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBCREATE_NOPARM::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBCREATE_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbCreate") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBFIND;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBFIND;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                if (method == null) {
                    return "ejbFind";
                }
                return method.getName();
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbFind";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CHKJ2502.ejbFind";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbFind";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBFIND::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbFind";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbFind");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                StringBuffer buffer = new StringBuffer("ejbFindByPrimaryKey(");
                String pkName = "";
                if (bean instanceof Entity) {
                    JavaClass pk = ((Entity)bean).getPrimaryKey();
                    pkName = pk == null ? "<primary-key>" : pk.getQualifiedName();
                }
                buffer.append(pkName);
                buffer.append(")");
                return buffer.toString();
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbFindByPrimaryKey";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbFind";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbFind") && method.getName().equals("ejbFindByPrimaryKey");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBHOME;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBHOME;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                if (method == null) {
                    return "ejbHome";
                }
                return method.getName();
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbHome";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBHOME::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbHome";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBHOME::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbHome";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbHome");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBLOAD_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBLOAD_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbLoad()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbLoad";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBLOAD::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EJBLOAD::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBLOAD::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBLOAD::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbLoad") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBPASSIVATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBPASSIVATE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbPassivate()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbPassivate";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBPASSIVATE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EJBPASSIVATE::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBPASSIVATE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBPASSIVATE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbPassivate") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBPOSTCREATE;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBPOSTCREATE;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbPostCreate";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "EJBPOSTCREATE::getMessageId_messageMissing";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBPOSTCREATE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbPostCreate";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBPOSTCREATE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBPOSTCREATE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbPostCreate");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBREMOVE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBREMOVE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbRemove()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbRemove";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBREMOVE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EJBREMOVE::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBREMOVE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBREMOVE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbRemove") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBSELECT;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBSELECT;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                if (method == null) {
                    return "ejbSelect";
                }
                return method.getName();
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbSelect";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CHKJ2502.ejbSelect";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EJBSELECT::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBSELECT::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBSELECT::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("ejbSelect");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBSTORE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EJBSTORE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "ejbStore()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbStore";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EJBSTORE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EJBSTORE::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EJBSTORE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBSTORE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("ejbStore") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EQUALS;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.EQUALS;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "equals(Object)";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.equals";
            }

            @Override
            public String getMessageId_messageExists() {
                return "EQUALS::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "EQUALS::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "EQUALS::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "EQUALS::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                JavaParameter[] parm;
                if (method == null) {
                    return false;
                }
                if (method.getName().startsWith("equals") && (parm = method.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers object = ValidationRuleUtility.getType("java.lang.Object", bean);
                        JavaHelpers parmType = parm[0].getJavaType();
                        if (object.equals(parmType)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.FIND;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.FIND;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                if (method == null) {
                    return "find";
                }
                return method.getName();
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.find";
            }

            @Override
            public String getMessageId_messageExists() {
                return "FIND::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.find";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.find";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.find";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("find");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.FINDBYPRIMARYKEY;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.FINDBYPRIMARYKEY;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "findByPrimaryKey";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.findByPrimaryKey";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CHKJ2500.find";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.find";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.find";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.find";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().startsWith("find") && method.getName().startsWith("findByPrimaryKey");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.FINALIZE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.FINALIZE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "finalize()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "FINALIZE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageExists() {
                return "CHKJ2502.finalize";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "FINALIZE::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "FINALIZE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "FINALIZE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("finalize") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.HASHCODE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.HASHCODE_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "hashCode()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.hashCode";
            }

            @Override
            public String getMessageId_messageExists() {
                return "HASHCODE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "HASHCODE::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "HASHCODE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "HASHCODE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("hashCode") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.HOME;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.HOME;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "home";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.home";
            }

            @Override
            public String getMessageId_messageExists() {
                return "HOME::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.home";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.home";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.home";
            }

            @Override
            public boolean isDefaultType() {
                return true;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                return method != null;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.ONMESSAGE;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.ONMESSAGE;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "onMessage";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.onMessage";
            }

            @Override
            public String getMessageId_messageExists() {
                return "ONMESSAGE::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "ONMESSAGE::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "ONMESSAGE::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "ONMESSAGE::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                JavaParameter[] parms;
                if (method == null) {
                    return false;
                }
                if (method.getName().equals("onMessage") && (parms = method.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers jmsMessage = ValidationRuleUtility.getType("javax.jms.Message", bean);
                        JavaHelpers parmType = parms[0].getJavaType();
                        if (jmsMessage.equals(parmType)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.SETENTITYCONTEXT;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.SETENTITYCONTEXT;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "setEntityContext";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.setEntityContext";
            }

            @Override
            public String getMessageId_messageExists() {
                return "SETENTITYCONTEXT::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "SETENTITYCONTEXT::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "SETENTITYCONTEXT::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "SETENTITYCONTEXT::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                JavaParameter[] parm;
                if (method == null) {
                    return false;
                }
                if (method.getName().equals("setEntityContext") && (parm = method.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers entityContext = ValidationRuleUtility.getType("javax.ejb.EntityContext", bean);
                        JavaHelpers parmType = parm[0].getJavaType();
                        if (entityContext.equals(parmType)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM;
            }

            @Override
            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method) {
                return "unsetEntityContext()";
            }

            @Override
            public String getMessageId_messageMissing() {
                return "CHKJ2050.unsetEntityContext";
            }

            @Override
            public String getMessageId_messageExists() {
                return "UNSETENTITYCONTEXT::getMessageId_messageExists";
            }

            @Override
            public String getMessageId_messageRemoteException() {
                return "UNSETENTITYCONTEXT::getMessageId_messageRemoteException";
            }

            @Override
            public String getMessageId_messageMissingMatching() {
                return "UNSETENTITYCONTEXT::getMessageId_messageMissingMatching";
            }

            @Override
            public String getMessageId_messageRMI_IIOPParm() {
                return "UNSETENTITYCONTEXT::getMessageId_messageRMI_IIOPParm";
            }

            @Override
            public boolean isDefaultType() {
                return false;
            }

            @Override
            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) {
                if (method == null) {
                    return false;
                }
                return method.getName().equals("unsetEntityContext") && method.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._fieldTypeIndex[fieldCount] = IMethodAndFieldConstants.SERIALVERSIONUID;
        this._fieldTypes[fieldCount++] = new IFieldType(){

            @Override
            public long getId() {
                return IMethodAndFieldConstants.SERIALVERSIONUID;
            }

            @Override
            public boolean isFieldType(EnterpriseBean bean, JavaClass clazz, Field field) {
                if (field == null) {
                    return false;
                }
                return field.getName().equals("serialVersionUID");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
    }
}

