/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.exception;

import java.util.Vector;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public abstract class AbstractCompositeExceptionHandler<H extends ExceptionHandler>
implements ExceptionHandler {
    private final Vector<H> exceptionHandlers = new Vector();

    protected AbstractCompositeExceptionHandler() {
    }

    protected AbstractCompositeExceptionHandler(H ... exceptionHandlers) {
        CollectionTools.addAll(this.exceptionHandlers, exceptionHandlers);
        this.checkExceptionHandlers();
    }

    protected AbstractCompositeExceptionHandler(Iterable<? extends H> exceptionHandlers) {
        CollectionTools.addAll(this.exceptionHandlers, exceptionHandlers);
        this.checkExceptionHandlers();
    }

    private void checkExceptionHandlers() {
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            if (exceptionHandler != null) continue;
            throw new NullPointerException();
        }
    }

    @Override
    public void handleException(Throwable t) {
        for (ExceptionHandler handler : this.getExceptionHandlers()) {
            handler.handleException(t);
        }
    }

    public Iterable<H> getExceptionHandlers() {
        return IterableTools.cloneSnapshot(this.exceptionHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionHandler(H exceptionHandler) {
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        Vector<H> vector = this.exceptionHandlers;
        synchronized (vector) {
            if (this.exceptionHandlers.contains(exceptionHandler)) {
                throw new IllegalArgumentException("duplicate handler: " + exceptionHandler);
            }
            this.exceptionHandlers.add(exceptionHandler);
        }
    }

    public void removeExceptionHandler(H exceptionHandler) {
        if (!this.exceptionHandlers.remove(exceptionHandler)) {
            throw new IllegalArgumentException("handler not registered: " + exceptionHandler);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.exceptionHandlers);
    }
}

