/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class NavigateToVarDeclAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        try {
            Object object = selection.getFirstElement();
            if (object instanceof IJavaVariable) {
                IStackFrame jFrame;
                IJavaVariable varE = (IJavaVariable)object;
                final String name = varE.getName();
                IAdaptable frame = DebugUITools.getDebugContext();
                if (frame instanceof IStackFrame && (jFrame = (IStackFrame)frame) instanceof IJavaStackFrame) {
                    IJavaStackFrame javaStackFrame = (IJavaStackFrame)jFrame;
                    final int currentLine = javaStackFrame.getLineNumber();
                    final String currentMethod = javaStackFrame.getMethodName();
                    List frameParams = javaStackFrame.getArgumentTypeNames();
                    final List ref = frameParams.stream().map(e -> {
                        int dot = e.lastIndexOf(46);
                        if (dot >= 0) {
                            return e.substring(dot + 1);
                        }
                        return e;
                    }).collect(Collectors.toList());
                    final ICompilationUnit[] cu = new ICompilationUnit[1];
                    IWorkbenchWindow window = this.getWorkbenchWindow();
                    final IEditorPart editor = window.getActivePage().getActiveEditor();
                    IJavaElement element = JavaUI.getEditorInputJavaElement((IEditorInput)editor.getEditorInput());
                    if (element instanceof ICompilationUnit) {
                        ICompilationUnit icu;
                        cu[0] = icu = (ICompilationUnit)element;
                    } else if (element instanceof IClassFile) {
                        IClassFile icf = (IClassFile)element;
                        cu[0] = icf.getWorkingCopy(new WorkingCopyOwner(){}, null);
                    } else {
                        cu[0] = null;
                    }
                    ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
                    parser.setSource(cu[0]);
                    parser.setKind(8);
                    parser.setResolveBindings(true);
                    ASTNode aSTNode = parser.createAST(null);
                    if (aSTNode instanceof CompilationUnit) {
                        final CompilationUnit ast = (CompilationUnit)aSTNode;
                        ast.accept(new ASTVisitor(){
                            boolean meth = false;
                            boolean found = false;
                            boolean inTargetContext = false;

                            public boolean visit(MethodDeclaration node) {
                                if (node.getName().getIdentifier().equals(currentMethod)) {
                                    List parameters = node.parameters();
                                    List<String> methodParams = parameters.stream().map(p -> ((SingleVariableDeclaration)p).getType().toString()).toList();
                                    int start = node.getStartPosition();
                                    int end = start + node.getLength();
                                    int startLine = ast.getLineNumber(start);
                                    int endLine = ast.getLineNumber(end);
                                    if (currentLine >= startLine && currentLine <= endLine) {
                                        this.inTargetContext = true;
                                        if (methodParams.equals(ref)) {
                                            this.meth = true;
                                            for (Object op : node.parameters()) {
                                                SingleVariableDeclaration param;
                                                if (!(op instanceof SingleVariableDeclaration) || !(param = (SingleVariableDeclaration)op).getName().getIdentifier().equals(name)) continue;
                                                ICompilationUnit finalCu = cu[0];
                                                NavigateToVarDeclAction.this.highlightLine(ast, finalCu, param.getStartPosition(), editor);
                                                this.found = true;
                                                return false;
                                            }
                                            return true;
                                        }
                                    }
                                }
                                return true;
                            }

                            public void endVisit(MethodDeclaration node) {
                                this.inTargetContext = false;
                            }

                            public boolean visit(VariableDeclarationFragment node) {
                                if (this.found) {
                                    return false;
                                }
                                if ((this.meth || this.inTargetContext) && node.getName().getIdentifier().equals(name)) {
                                    this.found = true;
                                    ICompilationUnit finalCu = cu[0];
                                    NavigateToVarDeclAction.this.highlightLine(ast, finalCu, node.getStartPosition(), editor);
                                    return false;
                                }
                                return true;
                            }

                            public boolean visit(LambdaExpression node) {
                                if (this.found) {
                                    return false;
                                }
                                List parameters = node.parameters();
                                int start = node.getStartPosition();
                                int end = start + node.getLength();
                                int startLine = ast.getLineNumber(start);
                                int endLine = ast.getLineNumber(end);
                                if (currentLine >= startLine && currentLine <= endLine) {
                                    this.inTargetContext = true;
                                    for (Object param : parameters) {
                                        SingleVariableDeclaration svd;
                                        if (!(param instanceof SingleVariableDeclaration) || !(svd = (SingleVariableDeclaration)param).getName().getIdentifier().equals(name)) continue;
                                        NavigateToVarDeclAction.this.highlightLine(ast, cu[0], svd.getStartPosition(), editor);
                                        this.found = true;
                                        return false;
                                    }
                                }
                                return true;
                            }

                            public void endVisit(LambdaExpression node) {
                                this.inTargetContext = false;
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e2) {
            DebugUIPlugin.log((Throwable)e2);
        }
    }

    private void highlightLine(CompilationUnit ast, ICompilationUnit cu, int startPos, IEditorPart editor) {
        int line = ast.getLineNumber(startPos);
        try {
            if (editor instanceof ITextEditor) {
                ITextEditor txtEd = (ITextEditor)editor;
                IDocumentProvider prov = txtEd.getDocumentProvider();
                IDocument doc = prov.getDocument((Object)txtEd.getEditorInput());
                int adjustedLine = Math.max(0, line - 1);
                IRegion lineReg = doc.getLineInformation(adjustedLine);
                txtEd.selectAndReveal(lineReg.getOffset(), lineReg.getLength());
            }
        }
        catch (Exception e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }
}

