/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.presentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.mapping.presentation.IComposedSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;

public class ComposedSelection
implements IStructuredSelection,
IComposedSelection,
ITreeSelection {
    protected ISelection[] selections;
    protected ISelection primarySelection;

    public ComposedSelection(ISelection primarySelection, ISelection[] selections) {
        this.primarySelection = primarySelection;
        this.selections = selections;
    }

    public boolean isEmpty() {
        return this.primarySelection == null || this.primarySelection.isEmpty();
    }

    @Deprecated
    public Iterator<?> getElements() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).iterator() : null;
    }

    public TreePath[] getPaths() {
        return this.primarySelection instanceof ITreeSelection ? ((ITreeSelection)this.primarySelection).getPaths() : null;
    }

    public TreePath[] getPathsFor(Object element) {
        return this.primarySelection instanceof ITreeSelection ? ((ITreeSelection)this.primarySelection).getPathsFor(element) : null;
    }

    public Iterator<?> iterator() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).iterator() : null;
    }

    public Object[] toArray() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).toArray() : null;
    }

    public List<?> toList() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).toList() : null;
    }

    public Object getFirstElement() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).getFirstElement() : null;
    }

    public Object getPrimaryItem() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).getFirstElement() : null;
    }

    public int size() {
        return this.primarySelection instanceof IStructuredSelection ? ((IStructuredSelection)this.primarySelection).size() : 0;
    }

    @Override
    public ISelection getSelection() {
        return this.primarySelection;
    }

    @Override
    public ISelection[] getSelections() {
        return this.selections;
    }

    @Override
    public IStructuredSelection getCombinedSelection() {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.selections.length) {
            ISelection selection = this.selections[i];
            if (selection instanceof IStructuredSelection) {
                List list = ((IStructuredSelection)selection).toList();
                result.addAll(list);
            }
            ++i;
        }
        return new StructuredSelection(result);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof IComposedSelection)) {
            return false;
        }
        IComposedSelection thatComposedSelection = (IComposedSelection)that;
        ISelection thatPrimarySelection = thatComposedSelection.getSelection();
        ISelection[] thatSelections = thatComposedSelection.getSelections();
        if (this.selections.length == thatSelections.length) {
            int i = 0;
            while (i < this.selections.length) {
                if (this.selections[i] == this.primarySelection && thatSelections[i] != thatPrimarySelection) {
                    return false;
                }
                if (!this.selections[i].equals(thatSelections[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ComposedSection(");
        if (this.selections != null) {
            int i = 0;
            while (i < this.selections.length) {
                if (this.selections[i] == this.primarySelection) {
                    result.append('(');
                    result.append(this.selections[i]);
                    result.append(')');
                } else {
                    result.append(this.selections[i]);
                }
                ++i;
            }
        }
        result.append(')');
        return result.toString();
    }
}

