/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import com.ibm.icu.util.ULocale;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.services.impl.ProviderUtil;

class ConnectionPropertyHandler
extends OdaObject {
    private String m_consumerApplId;
    private Object m_connPropContext;
    private IPropertyProvider m_propertyProvider;
    private ULocale m_appLocale;

    ConnectionPropertyHandler(Object context) {
        this.processConsumerAppContext(context);
    }

    protected String getConsumerApplicationId() {
        return this.m_consumerApplId;
    }

    protected Object getConnectionPropertyContext() {
        return this.m_connPropContext;
    }

    protected ULocale getAppLocale() {
        return this.m_appLocale;
    }

    private void processConsumerAppContext(Object context) {
        this.logMethodCalled("ConnectionPropertyHandler.processConsumerAppContext");
        this.m_consumerApplId = ProviderUtil.getConsumerApplicationId(context);
        this.log("ConnectionPropertyHandler.processConsumerAppContext", "Consumer Application ID: " + this.m_consumerApplId);
        this.m_connPropContext = ProviderUtil.getConnectionPropertyContext(context);
        this.log("ConnectionPropertyHandler.processConsumerAppContext", "Externalized property context: " + this.m_connPropContext);
        this.m_appLocale = this.getAppLocale(context);
        this.log("ConnectionPropertyHandler.processConsumerAppContext", "Application Locale in context: " + this.m_appLocale);
        this.logMethodExit("ConnectionPropertyHandler.processConsumerAppContext");
    }

    protected Properties getEffectiveProperties(Properties candidateProperties) throws OdaException {
        String methodName = "ConnectionPropertyHandler.getEffectiveProperties( " + candidateProperties + " )\t";
        this.logMethodCalled(methodName);
        IPropertyProvider propProvider = this.getExtensionPropertyProvider();
        if (propProvider == null) {
            this.logMethodExit(methodName);
            return candidateProperties;
        }
        Properties effectiveProps = propProvider.getDataSourceProperties(candidateProperties, this.getConnectionPropertyContext());
        this.log(methodName, "Effective properties: " + effectiveProps);
        this.logMethodExit(methodName);
        return effectiveProps;
    }

    private IPropertyProvider getExtensionPropertyProvider() throws OdaException {
        if (this.m_propertyProvider == null) {
            String applicationId = this.getConsumerApplicationId();
            this.m_propertyProvider = ProviderUtil.createPropertyProvider(applicationId);
        }
        return this.m_propertyProvider;
    }

    private ULocale getAppLocale(Object appContext) {
        if (appContext == null || !(appContext instanceof Map)) {
            return null;
        }
        String localeKey = "AppRuntimeLocale";
        Object localeValue = ((Map)appContext).get(localeKey);
        if (localeValue == null) {
            return null;
        }
        if (localeValue instanceof Locale) {
            return ULocale.forLocale((Locale)((Locale)localeValue));
        }
        if (localeValue instanceof ULocale) {
            return (ULocale)localeValue;
        }
        if (localeValue instanceof String) {
            String localeString = (String)localeValue;
            return new ULocale(localeString);
        }
        this.logWarning("getAppLocale(Object)", "Ignoring invalid object type (" + localeValue.getClass().getName() + ") specified for the application locale key " + localeKey);
        return null;
    }
}

